/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class FormatHelper {
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("d.M.yyyy");

    private FormatHelper() {
    }

    public static Date parseDate(String date) throws Exception {
        if (date == null || date.length() == 0) {
            return null;
        }
        Calendar aCalendar = FormatHelper.getCalendar(date);
        return aCalendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(Date value) {
        if (value == null) {
            return "";
        }
        DateFormat dateFormat = DATEFORMAT;
        synchronized (dateFormat) {
            return DATEFORMAT.format(value);
        }
    }

    public static String formatString(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String formatInt(int value) {
        return Integer.toString(value);
    }

    public static String formatLanguage(Locale language) {
        return language.getLanguage();
    }

    public static Locale parseLanguage(String language) {
        return new Locale(language);
    }

    public static Calendar getCalendar(String sString) {
        try {
            String sTempDate = "";
            sTempDate = sString.indexOf(".") == -1 ? (sString.length() == 6 ? sString.substring(0, 2) + "." + sString.substring(2, 4) + "." + sString.substring(4, 6) : (sString.length() == 8 ? sString.substring(0, 2) + "." + sString.substring(2, 4) + "." + sString.substring(4, 8) : sString)) : sString;
            String sDay = sTempDate.substring(0, sTempDate.indexOf("."));
            String sMonthYear = sTempDate.substring(sTempDate.indexOf(".") + 1, sTempDate.length());
            String sMonth = sMonthYear.substring(0, sMonthYear.indexOf("."));
            String sYear = sMonthYear.substring(sMonthYear.indexOf(".") + 1, sMonthYear.length());
            if (sYear.length() == 2) {
                int iYearTest = new Integer(sYear);
                sYear = iYearTest > 10 ? "19" + sYear : "20" + sYear;
            }
            int iYear = new Integer(sYear);
            int iMonth = new Integer(sMonth) - 1;
            int iDay = new Integer(sDay);
            Calendar aCalendar = Calendar.getInstance();
            aCalendar.set(14, 0);
            aCalendar.set(iYear, iMonth, iDay, 0, 0, 0);
            if (iMonth != aCalendar.get(2)) {
                return null;
            }
            if (iDay != aCalendar.get(5)) {
                return null;
            }
            return aCalendar;
        }
        catch (Exception e) {
            return null;
        }
    }
}

