/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.util;

import ch.dvbern.tax.common.transfer.util.Base64;
import ch.dvbern.tax.common.transfer.util.Base64URLSafe;
import java.io.UnsupportedEncodingException;

public class Base64Helper {
    private static final String CHARSET = "ISO-8859-1";

    private Base64Helper() {
    }

    public static String encode(String data) {
        try {
            return Base64Helper.encode(data.getBytes(CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encoding not supported: ISO-8859-1", e);
        }
    }

    public static String encode(byte[] data) {
        return Base64.encodeBytes(data);
    }

    public static byte[] decode(String data) {
        return Base64.decode(data);
    }

    public static String decodeAsString(String data) {
        try {
            return new String(Base64.decode(data), CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encoding not supported: ISO-8859-1", e);
        }
    }

    public static String encodeUrlSafe(byte[] data) {
        return Base64URLSafe.encode(data);
    }

    public static byte[] decodeUrlSafe(String encoded) {
        return Base64URLSafe.decode(encoded);
    }
}

