/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.ArrayList;
import java.util.List;

public class ZpvOrZeroConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3257852099294148152L;

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s != null) {
            s = s.replaceAll("'", "");
        }
        if (!this.isValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.zpv");
        }
        try {
            return new Long(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        if (this.isValid(o.toString())) {
            return o.toString();
        }
        return o.toString();
    }

    private boolean isPruefzifferValid(String sZahl) {
        int iZahl = new Integer(sZahl);
        int iPruefziffer = iZahl % 10;
        return iPruefziffer == this.berechnenPruefziffer(iZahl);
    }

    private int berechnenPruefziffer(int iZahl) {
        List vZiffern = this.ziffernReverse(iZahl /= 10);
        int summe = 0;
        for (int i = 0; i < vZiffern.size(); ++i) {
            if (this.odd(i)) {
                summe += ((Integer)vZiffern.get(i)).intValue();
                continue;
            }
            summe += this.querSumme((Integer)vZiffern.get(i) * 2);
        }
        return ((summe + 10) / 10 * 10 - summe) % 10;
    }

    public boolean isValid(String sZpv) {
        if (sZpv == null || sZpv.trim().equals("")) {
            return true;
        }
        try {
            if (Integer.parseInt(sZpv) != 0) {
                if (sZpv.length() != 8 && sZpv.length() != 9) {
                    return false;
                }
                return this.isPruefzifferValid(sZpv);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private List ziffernReverse(int iZahl) {
        ArrayList<Integer> vZiffern = new ArrayList<Integer>();
        while (iZahl != 0) {
            vZiffern.add(new Integer(iZahl % 10));
            iZahl /= 10;
        }
        return vZiffern;
    }

    private boolean odd(int iZahl) {
        return iZahl % 2 != 0;
    }

    private int querSumme(int iZahl) {
        int iQuerSumme = iZahl % 10;
        if (iZahl < 10) {
            return iQuerSumme;
        }
        return iQuerSumme + this.querSumme(iZahl /= 10);
    }

    public int getMaxLength() {
        return 10;
    }
}

