/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.ArrayList;
import java.util.List;

public class ZpvConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3258413941062578742L;

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s != null) {
            s = s.replaceAll("'", "");
        }
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (!this.isValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.zpv");
        }
        return new Long(s);
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    private int berechnenPruefziffer(int iZahl) {
        List vZiffern = this.ziffernReverse(iZahl /= 10);
        int summe = 0;
        for (int i = 0; i < vZiffern.size(); ++i) {
            if (this.odd(i)) {
                summe += ((Integer)vZiffern.get(i)).intValue();
                continue;
            }
            summe += this.querSumme((Integer)vZiffern.get(i) * 2);
        }
        return ((summe + 10) / 10 * 10 - summe) % 10;
    }

    protected boolean isPruefzifferValid(String sZahl) {
        try {
            int iZahl = new Integer(sZahl);
            int iPruefziffer = iZahl % 10;
            if (iPruefziffer == this.berechnenPruefziffer(iZahl)) {
                return true;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return false;
    }

    private boolean isValid(String sZpv) {
        if (sZpv.trim().equals("")) {
            return true;
        }
        if (sZpv.length() != 8 && sZpv.length() != 9) {
            return false;
        }
        return this.isPruefzifferValid(sZpv);
    }

    private boolean odd(int iZahl) {
        return iZahl % 2 != 0;
    }

    private int querSumme(int iZahl) {
        int iQuerSumme = iZahl % 10;
        if (iZahl < 10) {
            return iQuerSumme;
        }
        return iQuerSumme + this.querSumme(iZahl /= 10);
    }

    private List ziffernReverse(int iZahl) {
        ArrayList<Integer> vZiffern = new ArrayList<Integer>();
        while (iZahl != 0) {
            vZiffern.add(new Integer(iZahl % 10));
            iZahl /= 10;
        }
        return vZiffern;
    }

    public int getMaxLength() {
        return 10;
    }
}

