/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YearConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3763100777723475257L;
    private Pattern pattern = Pattern.compile("(19|20){1,1}[0-9]{2,2}");
    private boolean convertToText;

    public YearConverter() {
        this(false);
    }

    public YearConverter(boolean convertToText) {
        this.convertToText = convertToText;
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (s.length() != 4) {
            throw new AbstractConverter.ConvertException("error.format.year");
        }
        Matcher m = this.pattern.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.year");
        }
        Long result = new Long(s);
        if (result.intValue() < 1800) {
            throw new AbstractConverter.ConvertException("error.format.year.min", 1800);
        }
        if (this.convertToText) {
            return result.toString();
        }
        return result;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Float || o instanceof Double) {
            return Long.toString(Math.round(((Number)o).doubleValue()));
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "(19|20){0,1}[0-9]{0,2}";
    }
}

