/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;

public class TextConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3905807487042008886L;
    protected int maxLength;
    private boolean trimLeft = false;
    private boolean trimRight = false;

    public TextConverter(int maxLength) {
        this.maxLength = maxLength;
    }

    public TextConverter(int maxLength, boolean trimLeft, boolean trimRight) {
        this.maxLength = maxLength;
        this.trimLeft = trimLeft;
        this.trimRight = trimRight;
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (s.length() > this.maxLength) {
            throw new AbstractConverter.ConvertException("error.format.text", this.maxLength);
        }
        return s;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        String result = "";
        if (o instanceof String) {
            result = (String)o;
        } else if (o != null) {
            result = o.toString();
        }
        if (this.trimRight && result.length() > this.maxLength) {
            result = result.substring(0, this.maxLength);
        }
        if (this.trimLeft && result.length() > this.maxLength) {
            result = result.substring(result.length() - this.maxLength);
        }
        return result;
    }

    public int getMaxLength() {
        return this.maxLength;
    }
}

