/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.FloatConverter;
import ch.dvbern.tax.common.transfer.dto.convert.NumberConverter;

public class PrintZeroConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private NumberConverter nestedConverter;
    private boolean printZero;

    public PrintZeroConverter(NumberConverter nestedConverter, boolean printZero) {
        this.nestedConverter = nestedConverter;
        this.printZero = printZero;
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        return this.nestedConverter.getObject(s, optionItems);
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        Number number;
        if (this.printZero) {
            StringBuffer result = new StringBuffer(this.nestedConverter.getRenderedValue(o, readonly, optionItems, locHelper));
            if ("".equals(result.toString())) {
                FloatConverter floatConv;
                result = new StringBuffer("0");
                if (this.nestedConverter instanceof FloatConverter && !(floatConv = (FloatConverter)this.nestedConverter).isDynamicFP()) {
                    int numDec = floatConv.getNumDec();
                    result.append(".");
                    for (int i = 0; i < numDec; ++i) {
                        result.append("0");
                    }
                }
            }
            return result.toString();
        }
        if (o == null) {
            return "";
        }
        if (o instanceof Number && (number = (Number)o).doubleValue() == 0.0) {
            return "";
        }
        return this.nestedConverter.getRenderedValue(o, readonly, optionItems, locHelper);
    }

    public int getMaxLength() {
        return this.nestedConverter.getMaxLength();
    }
}

