/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IntMinMaxLengthConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3763100777723475257L;
    private Pattern pattern = Pattern.compile("[0-9]*");
    protected int maxLength;
    protected int minLength;
    String errorMax = "";
    String errorMin = "";
    private boolean convertToText;

    public IntMinMaxLengthConverter(int maxLength, int minLength) {
        this(maxLength, minLength, false);
    }

    public IntMinMaxLengthConverter(int maxLength, int minLength, boolean convertToText) {
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.errorMax = Integer.toString(maxLength);
        this.errorMin = Integer.toString(minLength);
        this.convertToText = convertToText;
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (s.length() > this.maxLength) {
            throw new AbstractConverter.ConvertException("error.format.int-simple.max." + this.errorMax);
        }
        if (s.length() < this.minLength) {
            throw new AbstractConverter.ConvertException("error.format.int-simple.min." + this.errorMin);
        }
        Matcher m = this.pattern.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.int-simple");
        }
        Long result = new Long(s);
        if (this.convertToText) {
            return result.toString();
        }
        return result;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Float || o instanceof Double) {
            return Long.toString(Math.round(((Number)o).doubleValue()));
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "([0-9]){1," + this.maxLength + "}";
    }
}

