/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.NumberConverter;
import java.text.DecimalFormat;

public class IntConverter
extends NumberConverter {
    private static final long serialVersionUID = 3257282526450890292L;
    private static final DecimalFormat df_int = IntConverter.createDecimalFormat("#,##0");
    private boolean printZeroIfReadonly;

    public IntConverter(int maxLength, boolean printZeroIfReadonly) {
        super(maxLength);
        this.printZeroIfReadonly = printZeroIfReadonly;
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        try {
            if (this.calcLength(s) > this.maxLength) {
                throw new AbstractConverter.ConvertException("error.format.int", this.maxLength);
            }
            s = s.replaceAll("'", "");
            return Long.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            throw new AbstractConverter.ConvertException("error.format.int", this.maxLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        if (o == null) {
            return "";
        }
        if (o instanceof Number) {
            long value = o instanceof Float || o instanceof Double ? Math.round(((Number)o).doubleValue()) : ((Number)o).longValue();
            if (value == 0L && readonly && !this.printZeroIfReadonly) {
                return "";
            }
            DecimalFormat decimalFormat = df_int;
            synchronized (decimalFormat) {
                return df_int.format(value);
            }
        }
        return o.toString();
    }

    public String getUserInputRegExpPattern() {
        return "((-)?[0-9|\\']*)";
    }
}

