/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;

public class FirstLetterConverter
extends AbstractConverter {
    private static final long serialVersionUID = 3257569524822914358L;
    private int chars;

    public FirstLetterConverter(int chars) {
        this.chars = chars;
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        return s;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        try {
            String key = o.toString();
            OptionItemDTO option = optionItems.get(key, locHelper.getCurrentLocale());
            if (option != null) {
                if (option.isResourceKey()) {
                    return locHelper.translate(option.getText().toString(), null).substring(0, this.chars);
                }
                return option.getText().toString().substring(0, this.chars);
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }
}

