/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.Float2Converter;
import java.text.DecimalFormat;
import java.util.regex.Pattern;

public class CurrencyConverter
extends Float2Converter {
    private static final long serialVersionUID = 3256436997781338163L;
    public static final DecimalFormat DATE_FORMAT_CURRENCY_WITHOUT_GROUPING = CurrencyConverter.createDecimalFormatWithoutGrouping("###0.00");

    public CurrencyConverter(int maxLength) {
        super(maxLength, false);
    }

    protected static DecimalFormat createDecimalFormatWithoutGrouping(String pattern) {
        DecimalFormat df = new DecimalFormat(pattern, dfs);
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        df.setDecimalSeparatorAlwaysShown(false);
        return df;
    }

    public String getUserInputRegExpPattern() {
        return "([0-9]|[1-9][0-9]+)\\.[0-9](0|5)";
    }

    public Object getObject(String s, OptionItemsDTO optionItems) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        try {
            s = s.replaceAll("'", "");
            this.checkFloatingPointNumberLength(s, this.maxLength, this.numDec);
            Double result = Double.valueOf(s);
            String rendered = this.getRenderedValue(result, false, optionItems, null);
            rendered = rendered.replaceAll("'", "");
            this.checkCurrency(rendered, this.maxLength, this.numDec);
            return result;
        }
        catch (NumberFormatException nfe) {
            throw new AbstractConverter.ConvertException("error.format.float-" + this.numDec, this.maxLength - this.numDec + 1);
        }
        catch (CurrencyException e) {
            throw new AbstractConverter.ConvertException("error.format.currency");
        }
    }

    protected void checkCurrency(String value, int totalLength, int lengthAfterPoint) throws CurrencyException {
        String newRegex = this.getUserInputRegExpPattern();
        if (!Pattern.matches(newRegex, value)) {
            throw new CurrencyException();
        }
    }

    static class CurrencyException
    extends Exception {
        private static final long serialVersionUID = 1L;

        CurrencyException() {
        }
    }
}

