/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.SelectConverter;

public class ComboboxConverter
extends SelectConverter {
    private static final long serialVersionUID = 3257848779318177842L;
    private boolean useShortText;

    public ComboboxConverter(boolean useShortText) {
        this.useShortText = useShortText;
    }

    public String getRenderedValue(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        try {
            String key = o.toString();
            OptionItemDTO option = optionItems.get(key, locHelper.getCurrentLocale());
            return this.getRenderedValue(option, locHelper);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getRenderedValue(OptionItemDTO option, LocalizationHelper locHelper) {
        try {
            if (option != null) {
                String text;
                String string = text = this.useShortText ? option.getShortText().toString() : option.getText().toString();
                if (option.isResourceKey()) {
                    return locHelper.translate(text, null);
                }
                return text;
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }
}

