/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import java.io.Serializable;

public abstract class AbstractConverter
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract Object getObject(String var1, OptionItemsDTO var2) throws ConvertException;

    public abstract String getRenderedValue(Object var1, boolean var2, OptionItemsDTO var3, LocalizationHelper var4);

    public String getRenderedValueToPrint(Object o, boolean readonly, OptionItemsDTO optionItems, LocalizationHelper locHelper) {
        return this.getRenderedValue(o, readonly, optionItems, locHelper);
    }

    public String getUserInputRegExpPattern() {
        return ".*";
    }

    public int getMaxLength() {
        return 1000;
    }

    public int calcLength(String input) {
        if (input == null) {
            return 0;
        }
        return input.length();
    }

    public static class ConvertException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int maxLength;

        public ConvertException(String message) {
            super(message);
        }

        public ConvertException(String message, Throwable throwable) {
            super(message, throwable);
        }

        public ConvertException(String message, int maxLength) {
            super(message);
            this.maxLength = maxLength;
        }

        public ConvertException(String message, Throwable throwable, int maxLength) {
            super(message, throwable);
            this.maxLength = maxLength;
        }

        public Integer getMaxLength() {
            return new Integer(this.maxLength);
        }
    }
}

