/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class ModelItemDTO
implements Serializable {
    private static final long serialVersionUID = -1013017344496997291L;
    public static final int STATE_OK = 1;
    public static final int STATE_WARNING = 2;
    public static final int STATE_MISSINGVALUE = 3;
    public static final int STATE_ERROR = 4;
    public static final int STATE_TRANSPARENT = 11;
    public static final int STATE_DISABLED = 12;
    private Object value;
    private int state;
    private Collection messages;
    private boolean touched = false;

    public ModelItemDTO() {
        this.state = 9;
    }

    public ModelItemDTO(Object value) {
        this(value, 1, null);
    }

    public ModelItemDTO(Object value, int state) {
        this(value, state, null);
    }

    public ModelItemDTO(Object value, int state, Collection msg) {
        this.value = value;
        this.state = state;
        this.messages = msg;
    }

    public ModelItemDTO clone(Object newValue) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = newValue;
        result.state = this.state;
        result.messages = this.messages;
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(int newState) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = this.value;
        result.state = newState;
        result.messages = this.messages;
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(Object newValue, int newState, Collection msg) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = newValue;
        result.state = newState;
        result.messages = msg;
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(int newState, Collection msg) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = this.value;
        result.state = newState;
        result.messages = msg;
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(int newState, String messageKey, Object messageValue, int messageType) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = this.value;
        result.state = newState;
        result.messages = new ArrayList();
        if (this.messages != null) {
            result.messages.addAll(this.messages);
        }
        result.messages.add(new MessageItemDTO(messageKey, messageValue, messageType));
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(String messageKey, Object messageValue, int messageType) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = this.value;
        result.state = this.state;
        result.messages = new ArrayList();
        if (this.messages != null) {
            result.messages.addAll(this.messages);
        }
        result.messages.add(new MessageItemDTO(messageKey, messageValue, messageType));
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO clone(Object newValue, int newState, String messageKey, Object messageValue, int messageType) {
        ModelItemDTO result = new ModelItemDTO();
        result.value = newValue;
        result.state = newState;
        result.messages = new ArrayList();
        if (this.messages != null) {
            result.messages.addAll(this.messages);
        }
        result.messages.add(new MessageItemDTO(messageKey, messageValue, messageType));
        result.touched = this.touched;
        return result;
    }

    public ModelItemDTO cloneUntouched() {
        ModelItemDTO result = new ModelItemDTO();
        result.value = this.value;
        result.state = this.state;
        result.messages = this.messages;
        result.touched = false;
        return result;
    }

    public Object getValue() {
        return this.value;
    }

    public int getState() {
        return this.state;
    }

    public Collection getMessages() {
        return this.messages;
    }

    public boolean isTouched() {
        return this.touched;
    }

    public void setTouched() {
        this.touched = true;
    }

    public boolean hasMoreImportantState(int otherState) {
        return ModelItemDTO.isMoreImportantState(this.state, otherState);
    }

    public static boolean isMoreImportantState(int state1, int state2) {
        return state1 > state2;
    }

    public boolean hasPropagatableState() {
        return ModelItemDTO.isPropagatableState(this.state);
    }

    public static boolean isPropagatableState(int state) {
        return state != 11 && state != 12;
    }

    public boolean equals(Object obj) {
        if (!this.valueIsEqual(obj)) {
            return false;
        }
        ModelItemDTO miDTO = (ModelItemDTO)obj;
        if (this.getState() != miDTO.getState()) {
            return false;
        }
        if (this.isTouched() != miDTO.isTouched()) {
            return false;
        }
        if (this.messages == null) {
            return miDTO.getMessages() == null;
        }
        return ((Object)this.messages).equals(miDTO.getMessages());
    }

    public int hashCode() {
        int hash = 1;
        if (this.value != null) {
            hash = hash * 31 + this.value.hashCode();
        }
        if (this.messages != null) {
            hash = hash * 31 + ((Object)this.messages).hashCode();
        }
        return hash;
    }

    public boolean valueIsEqual(Object obj) {
        if (!(obj instanceof ModelItemDTO)) {
            return false;
        }
        if (this.value == null) {
            return ((ModelItemDTO)obj).getValue() == null;
        }
        return this.value.equals(((ModelItemDTO)obj).getValue());
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }
}

