/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpertDisplayInfoDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_RADIO = 1;
    public static final int TYPE_COMBO = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int TYPE_TEXTAREA = 4;
    public static final int OUTPUT_NO_PAGE = 0;
    public static final int OUTPUT_FIRST_PAGE = 1;
    public static final int OUTPUT_LAST_PAGE = 2;
    public static final int OUTPUT_EXTRA_PAGES = 4;
    public static final int OUTPUT_ALL_PAGES = 8;
    public static final int MODE_INPUT = 1;
    public static final int MODE_PRINT = 2;
    private String name;
    private PageSettingsDTO pagesettings;
    private List items;
    private ImageDTO guiBackground;
    private ImageDTO printBackground;
    private ImageDTO extraPagesBackground;
    private List navigationItems;
    private Collection deleteWarnings;
    private Collection messages;
    private String uniqueItemIdentifier;
    private String accessKey;
    private int valuePrintPaddingX;

    public ExpertDisplayInfoDTO(String name, PageSettingsDTO pagesettings, List items, ImageDTO guiBackground, ImageDTO printBackground, List navigationItems, ImageDTO extraPagesBackground, String uniqueItemIdentifier, String accessKey, int valuePrintPaddingX) {
        this.name = name;
        this.pagesettings = pagesettings;
        this.items = items;
        this.guiBackground = guiBackground;
        this.printBackground = printBackground;
        this.navigationItems = navigationItems;
        this.extraPagesBackground = extraPagesBackground;
        this.uniqueItemIdentifier = uniqueItemIdentifier;
        this.accessKey = accessKey;
        this.valuePrintPaddingX = valuePrintPaddingX;
    }

    public String getName() {
        return this.name;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public PageSettingsDTO getPageSize() {
        return this.pagesettings;
    }

    public List getItems() {
        return this.items;
    }

    public ImageDTO getGuiBackground() {
        return this.guiBackground;
    }

    public ImageDTO getPrintBackground() {
        return this.printBackground;
    }

    public ImageDTO getExtraPagesBackground() {
        return this.extraPagesBackground;
    }

    public List getNavigationItems() {
        return this.navigationItems;
    }

    public Collection getMessages() {
        if (this.messages == null) {
            this.refreshMessages();
        }
        return this.messages;
    }

    public String getUniqueItemIdentifier() {
        return this.uniqueItemIdentifier;
    }

    public void refreshMessages() {
        this.refreshMessages(Collections.EMPTY_SET);
    }

    public void refreshMessages(Set dmksToIgnore) {
        this.messages = new LinkedHashSet();
        if (this.items != null) {
            Iterator iter = this.items.iterator();
            while (iter.hasNext()) {
                ItemDTO formChild = (ItemDTO)iter.next();
                if (formChild instanceof ValueItemDTO) {
                    ValueItemDTO valueDTO = (ValueItemDTO)formChild;
                    if (valueDTO.getModelItem() == null || valueDTO.getModelItem().getMessages() == null || dmksToIgnore.contains(valueDTO.getDataModelKey())) continue;
                    this.messages.addAll(valueDTO.getModelItem().getMessages());
                    continue;
                }
                if (formChild instanceof ButtonDTO) {
                    ButtonDTO buttonDto = (ButtonDTO)formChild;
                    if (buttonDto.getMessages() == null) continue;
                    this.messages.addAll(buttonDto.getMessages());
                    continue;
                }
                if (!(formChild instanceof TableDTO)) continue;
                TableDTO tableDTO = (TableDTO)formChild;
                List rows = tableDTO.getInputRows();
                Iterator iterRows = rows.iterator();
                while (iterRows.hasNext()) {
                    TableDTO.RowDTO rowDTO = (TableDTO.RowDTO)iterRows.next();
                    List values = rowDTO.getValues();
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext()) {
                        TableDTO.ValueCellDTO valueCellDTO;
                        if (((TableDTO)formChild).isEnhanced()) {
                            ValueItemDTO valueDTO;
                            Object formElement = iterator.next();
                            if (!(formElement instanceof ValueItemDTO) || (valueDTO = (ValueItemDTO)formElement).getModelItem() == null || valueDTO.getModelItem().getMessages() == null || dmksToIgnore.contains(valueDTO.getDataModelKey())) continue;
                            this.messages.addAll(valueDTO.getModelItem().getMessages());
                            continue;
                        }
                        TableDTO.CellDTO cellDTO = (TableDTO.CellDTO)iterator.next();
                        if (!(cellDTO instanceof TableDTO.ValueCellDTO) || (valueCellDTO = (TableDTO.ValueCellDTO)cellDTO).getModelItem() == null || valueCellDTO.getModelItem().getMessages() == null || dmksToIgnore.contains(valueCellDTO.getDataModelKey())) continue;
                        this.messages.addAll(valueCellDTO.getModelItem().getMessages());
                    }
                }
            }
        }
        Iterator it = this.messages.iterator();
        while (it.hasNext()) {
            MessageItemDTO msg = (MessageItemDTO)it.next();
            if (msg.getKey() != null && msg.getKey().trim().length() >= 1) continue;
            it.remove();
        }
    }

    public boolean isHasMessages() {
        return !this.getMessages().isEmpty();
    }

    public void setDeleteWarnings(Collection deleteWarnings) {
        this.deleteWarnings = deleteWarnings;
    }

    public Collection getDeleteWarnings() {
        return this.deleteWarnings;
    }

    public int getState() {
        int result = 1;
        if (this.navigationItems != null) {
            Iterator i = this.navigationItems.iterator();
            while (i.hasNext()) {
                NavigationDTO nDTO = (NavigationDTO)i.next();
                int state = nDTO.getState();
                if (state == 2 && ModelItemDTO.isMoreImportantState(state, result)) {
                    result = state;
                }
                if (state == 3 && ModelItemDTO.isMoreImportantState(state, result)) {
                    result = state;
                }
                if (state != 4 || !ModelItemDTO.isMoreImportantState(state, result)) continue;
                result = state;
            }
        }
        return result;
    }

    public int getValuePrintPaddingX() {
        return this.valuePrintPaddingX;
    }

    public static String getLabelText(String key, List labelAddOns, LocalizationHelper locHelper) {
        if (key == null) {
            return "";
        }
        try {
            if (labelAddOns != null) {
                Object[] values = new Object[labelAddOns.size()];
                for (int i = 0; i < values.length; ++i) {
                    LabelDTO.LabelAddOnDTO addOn = (LabelDTO.LabelAddOnDTO)labelAddOns.get(i);
                    AbstractConverter conv = addOn.getRendererAndInputValidator();
                    values[i] = conv.getRenderedValue(addOn.getValue(), false, addOn.getOptionItems(), locHelper);
                }
                return locHelper.translate(key, values);
            }
            return locHelper.translate(key, null);
        }
        catch (LocalizationHelper.LocalizationHelperException lhe) {
            return lhe.toString();
        }
    }

    public static class NavigationDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int state;
        private String formName;
        private String accessKey;
        private String iconName;
        private List subItems;
        private boolean selected;
        private NavigationDTO parent;
        private String tableEntryDMK;
        private boolean extraForm;
        private int printState;
        private String descriptionKey;
        private List desciptionAddOns;
        private boolean deleteable;
        private boolean editable;
        private NavigationDTO newEntryItem;
        private String uniqueItemIdentifier;
        private boolean printGesamtausdruck;
        private boolean printEinzeldruck;

        public NavigationDTO(int state, String formName, String accessKey, String iconName, List subItems, boolean selected, String tableEntryDMK, boolean extraForm, int printState, String descriptionKey, List descriptionAddOns, boolean deleteable, boolean editable, NavigationDTO newEntryItem, String uniqueItemIdentifier, boolean printGesamtausdruck, boolean printEinzeldruck) {
            this.state = state;
            this.formName = formName;
            this.iconName = iconName;
            this.subItems = subItems;
            this.selected = selected;
            this.accessKey = accessKey;
            this.tableEntryDMK = tableEntryDMK;
            this.extraForm = extraForm;
            this.printState = printState;
            this.descriptionKey = descriptionKey;
            this.desciptionAddOns = descriptionAddOns;
            this.deleteable = deleteable;
            this.editable = editable;
            this.newEntryItem = newEntryItem;
            this.uniqueItemIdentifier = uniqueItemIdentifier;
            this.printGesamtausdruck = printGesamtausdruck;
            this.printEinzeldruck = printEinzeldruck;
            if (subItems != null) {
                Iterator iter = subItems.iterator();
                while (iter.hasNext()) {
                    NavigationDTO element = (NavigationDTO)iter.next();
                    element.parent = this;
                }
            }
        }

        public String getFormName() {
            return this.formName;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getIconName() {
            return this.iconName;
        }

        public int getState() {
            return this.state;
        }

        public int getPrintState() {
            return this.printState;
        }

        public List getSubItems() {
            return this.subItems;
        }

        public int getSubItemsCount() {
            if (this.subItems == null) {
                return 0;
            }
            return this.subItems.size();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public NavigationDTO getParent() {
            return this.parent;
        }

        public String getTableEntryDMK() {
            return this.tableEntryDMK;
        }

        public boolean isExtraForm() {
            return this.extraForm;
        }

        public String getDescriptionKey() {
            return this.descriptionKey;
        }

        public List getDesciptionAddOns() {
            return this.desciptionAddOns;
        }

        public boolean isDeleteable() {
            return this.deleteable;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public NavigationDTO getNewEntryItem() {
            return this.newEntryItem;
        }

        public String getUniqueItemIdentifier() {
            return this.uniqueItemIdentifier;
        }

        public boolean isPrintGesamtausdruck() {
            return this.printGesamtausdruck;
        }

        public void setPrintGesamtausdruck(boolean printGesamtausdruck) {
            this.printGesamtausdruck = printGesamtausdruck;
        }

        public boolean isPrintEinzeldruck() {
            return this.printEinzeldruck;
        }

        public void setPrintEinzeldruck(boolean printEinzeldruck) {
            this.printEinzeldruck = printEinzeldruck;
        }
    }

    public static class LinkItemDTO
    extends ItemDTO {
        private static final long serialVersionUID = 3258126951381481014L;
        private String text;
        private String formularKey;
        private ColorDTO color;
        private ColorDTO colorMouseOver;
        private FontDTO font;

        public LinkItemDTO(int x, int y, int width, int height, String text, String formularKey, ColorDTO color, ColorDTO colorMouseOver, ColorDTO bgColor, FontDTO font, String uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, 0, uniqueItemIdentifier);
            this.text = text;
            this.formularKey = formularKey;
            this.color = color;
            this.colorMouseOver = colorMouseOver;
            this.font = font;
        }

        public String getFormularKey() {
            return this.formularKey;
        }

        public String getText(LocalizationHelper localizationHelper) {
            try {
                return localizationHelper.translate(this.text, null);
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                return e.toString();
            }
        }

        public ColorDTO getColor() {
            return this.color;
        }

        public ColorDTO getColorMouseOver() {
            return this.colorMouseOver;
        }

        public FontDTO getFont() {
            return this.font;
        }

        public String getItemType() {
            return "LINK";
        }
    }

    public static class ColorDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int red;
        private int green;
        private int blue;
        private String hexColor;

        public ColorDTO(int r, int g, int b) {
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }

        public String toString() {
            if (this.hexColor == null) {
                this.hexColor = this.getHexColor(this);
            }
            return this.hexColor;
        }

        private String getHexColor(ColorDTO color) {
            StringBuffer sb = new StringBuffer(7);
            sb.append("#");
            this.appendColor(sb, color.getRed());
            this.appendColor(sb, color.getGreen());
            this.appendColor(sb, color.getBlue());
            return sb.toString();
        }

        private void appendColor(StringBuffer sb, int color) {
            if (color < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(color).toUpperCase());
        }
    }

    public static class ValuePositionDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String value;
        private int x;
        private int y;
        private int width;
        private int height;

        public ValuePositionDTO(String value, int x, int y, int width, int height) {
            this.value = value;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public String getValue() {
            return this.value;
        }

        public int getX() {
            return this.x;
        }

        public int getX(float zoom) {
            return Math.round((float)this.x * zoom);
        }

        public int getY() {
            return this.y;
        }

        public int getY(float zoom) {
            return Math.round((float)this.y * zoom);
        }

        public int getWidth() {
            return this.width;
        }

        public int getWidth(float zoom) {
            return Math.round((float)this.width * zoom);
        }

        public int getHeight() {
            return this.height;
        }

        public int getHeight(float zoom) {
            return Math.round((float)this.height * zoom);
        }
    }

    public static class PatternDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private float size;
        private float distance;
        private ColorDTO color;

        public PatternDTO(float size, float distance, ColorDTO color) {
            this.size = size;
            this.distance = distance;
            this.color = color;
        }

        public float getSize() {
            return this.size;
        }

        public float getDistance() {
            return this.distance;
        }

        public ColorDTO getColor() {
            return this.color;
        }
    }

    public static class FontDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int STYLE_NORMAL = 0;
        public static final int STYLE_BOLD = 1;
        public static final int STYLE_ITALIC = 2;
        public static final int STYLE_UNDERLINED = 4;
        private String name;
        private float size;
        private int style;
        private ColorDTO color;
        private float charSpace;
        private String toString;

        public FontDTO(String name, float size, int style, ColorDTO color, float charSpace) {
            this.name = name;
            this.size = size;
            this.style = style;
            this.color = color;
            this.charSpace = charSpace;
        }

        public String getName() {
            return this.name;
        }

        public float getSize() {
            return this.size;
        }

        public int getStyle() {
            return this.style;
        }

        public ColorDTO getColor() {
            return this.color;
        }

        public float getCharSpace() {
            return this.charSpace;
        }

        public String getStyletext() {
            if (this.style == 1) {
                return "bold";
            }
            if (this.style == 2) {
                return "italic";
            }
            if (this.style == 4) {
                return "underlined";
            }
            return "";
        }

        public String toString() {
            if (this.toString == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.name);
                sb.append("-");
                sb.append(this.size);
                sb.append("-");
                sb.append(this.style);
                sb.append("-");
                sb.append(this.color);
                sb.append("-");
                sb.append(this.charSpace);
                this.toString = sb.toString();
            }
            return this.toString;
        }
    }

    public static class TableDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int headerHeight;
        private int formRows;
        private FontDTO titleFont;
        private PatternDTO titlePattern;
        private List printColumns;
        private List inputColumns;
        private List allColumns;
        private List printRows;
        private List inputRows;
        private List allRows;
        private int state;
        private boolean readonly;
        private boolean enhanced;
        private float rowHeight;
        private float colSpace;
        private float extraPagesRowPadding;
        private String title;
        private String dataModelKey;
        private String logicModelKey;
        private ColorDTO borderColor;
        private boolean editable;
        private boolean headerVisible;
        private int startRow;
        private int endRow;

        public TableDTO(int x, int y, int width, int height, int headerHeight, int formRows, FontDTO titleFont, PatternDTO titlePattern, ColorDTO bgColor, List columns, List rows, int state, boolean readonly, boolean enhanced, int printMode, float rowHeight, float colSpace, String title, ColorDTO borderColor, float extraPagesRowPadding, String dataModelKey, String uniqueItemIdentifier, boolean headerVisible, boolean editable, int startRow, int endRow) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            Serializable col;
            Iterator it;
            this.headerHeight = headerHeight;
            this.formRows = formRows;
            this.state = state;
            this.readonly = readonly;
            this.rowHeight = rowHeight;
            this.enhanced = enhanced;
            this.title = title;
            this.titleFont = titleFont;
            this.titlePattern = titlePattern;
            this.colSpace = colSpace;
            this.borderColor = borderColor;
            this.extraPagesRowPadding = extraPagesRowPadding;
            this.dataModelKey = dataModelKey;
            this.logicModelKey = dataModelKey == null ? null : EngineUtil.removeTableIndices(dataModelKey);
            this.headerVisible = headerVisible;
            this.editable = editable;
            this.startRow = startRow;
            this.endRow = endRow;
            if (!enhanced) {
                this.allColumns = columns;
                this.inputColumns = new ArrayList();
                this.printColumns = new ArrayList();
                it = columns.iterator();
                while (it.hasNext()) {
                    col = (ColumnDTO)it.next();
                    if (((ColumnDTO)col).isInputColumn()) {
                        this.inputColumns.add(col);
                    }
                    if (!((ColumnDTO)col).isPrintColumn()) continue;
                    this.printColumns.add(col);
                }
            }
            this.allRows = rows;
            this.inputRows = new ArrayList();
            this.printRows = new ArrayList();
            it = rows.iterator();
            while (it.hasNext()) {
                col = (RowDTO)it.next();
                if (((RowDTO)col).isInputRow()) {
                    this.inputRows.add(col);
                }
                if (!((RowDTO)col).isPrintRow()) continue;
                this.printRows.add(col);
            }
        }

        public String getDataModelKey() {
            return this.dataModelKey;
        }

        public String getLogicModelKey() {
            return this.logicModelKey;
        }

        public String getTitle() {
            return this.title;
        }

        public FontDTO getTitleFont() {
            return this.titleFont;
        }

        public PatternDTO getTitlePattern() {
            return this.titlePattern;
        }

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public int getFormRows() {
            return this.formRows;
        }

        public List getInputColumns() {
            return this.inputColumns;
        }

        public List getPrintColumns() {
            return this.printColumns;
        }

        public List getAllColumns() {
            return this.allColumns;
        }

        public List getInputRows() {
            return this.inputRows;
        }

        public List getAllRows() {
            return this.allRows;
        }

        public List getPrintRows() {
            return this.printRows;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public int getState() {
            return this.state;
        }

        public float getRowHeight() {
            return this.rowHeight;
        }

        public float getColSpace() {
            return this.colSpace;
        }

        public boolean isEnhanced() {
            return this.enhanced;
        }

        public ColorDTO getBorderColor() {
            return this.borderColor;
        }

        public float getExtraPagesRowPadding() {
            return this.extraPagesRowPadding;
        }

        public String getItemType() {
            return "TABLE";
        }

        public void setEnhanced(boolean enhanced) {
            this.enhanced = enhanced;
        }

        public boolean isHeaderVisible() {
            return this.headerVisible;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getEndRow() {
            return this.endRow;
        }

        public static class ExtraPagesSumDTO
        extends TextItemDTO {
            private static final long serialVersionUID = 1L;

            public ExtraPagesSumDTO(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, int printMode, String uniqueItemIdentifier) {
                super(x, y, width, height, font, bgColor, alignment, printMode, uniqueItemIdentifier);
            }

            public String getItemType() {
                return "ExtraPagesSumPos";
            }
        }

        public static class ButtonCellDTO
        extends CellDTO {
            private static final long serialVersionUID = 1L;
            private String commandDmk;
            private String valueDmk;
            private String key;
            private String icon;
            private String uri;
            private ModelItemDTO commandItem;

            public ButtonCellDTO(String commandDmk, String valueDmk, String key, String icon, String uri, ModelItemDTO commandItem, int colspan, String uniqueItemIdentifier, FontDTO font, String reRender) {
                super(colspan, uniqueItemIdentifier, font, reRender);
                this.commandDmk = commandDmk;
                this.valueDmk = valueDmk;
                this.key = key;
                this.icon = icon;
                this.uri = uri;
                this.commandItem = commandItem;
            }

            public String getCommandDmk() {
                return this.commandDmk;
            }

            public String getValueDmk() {
                return this.valueDmk;
            }

            public String getKey() {
                return this.key;
            }

            public String getIcon() {
                return this.icon;
            }

            public String getUri() {
                return this.uri;
            }

            public ModelItemDTO getCommandItem() {
                return this.commandItem;
            }
        }

        public static class LabelCellDTO
        extends CellDTO {
            private static final long serialVersionUID = 1L;
            private String key;
            private List labelAddOns;

            public LabelCellDTO(String key, List labelAddOns, int colspan, String uniqueItemIdentifier, FontDTO font) {
                super(colspan, uniqueItemIdentifier, font, null);
                this.key = key;
                this.labelAddOns = labelAddOns;
            }

            public String getKey() {
                return this.key;
            }

            public String getText(LocalizationHelper localizationHelper) {
                return ExpertDisplayInfoDTO.getLabelText(this.key, this.labelAddOns, localizationHelper);
            }

            public List getLabelAddOns() {
                return this.labelAddOns;
            }
        }

        public static class ValueCellDTO
        extends CellDTO {
            private static final long serialVersionUID = 1L;
            private String dmk;
            private ModelItemDTO modelItem;
            private OptionItemsDTO optionItems;

            public ValueCellDTO(String dmk, ModelItemDTO modelItem, OptionItemsDTO optionItems, int colspan, String uniqueItemIdentifier, FontDTO font, String reRender) {
                super(colspan, uniqueItemIdentifier, font, reRender);
                this.dmk = dmk;
                this.modelItem = modelItem;
                this.optionItems = optionItems;
            }

            public String getDataModelKey() {
                return this.dmk;
            }

            public ModelItemDTO getModelItem() {
                return this.modelItem;
            }

            public void setModelItem(ModelItemDTO modelItem) {
                this.modelItem = modelItem;
            }

            public OptionItemsDTO getOptionItems() {
                return this.optionItems;
            }
        }

        public static abstract class CellDTO
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private int colspan;
            private String uniqueItemIdentifier;
            private FontDTO font;
            private String reRender;

            public CellDTO(int colspan, String uniqueItemIdentifier, FontDTO font, String reRender) {
                this.colspan = colspan;
                this.uniqueItemIdentifier = uniqueItemIdentifier;
                this.font = font;
                this.reRender = reRender;
            }

            public int getColspan() {
                return this.colspan;
            }

            public void setColspan(int colspan) {
                this.colspan = colspan;
            }

            public String getUniqueItemIdentifier() {
                return this.uniqueItemIdentifier;
            }

            public FontDTO getFont() {
                return this.font;
            }

            public String getReRender() {
                return this.reRender;
            }
        }

        public static class RowDTO
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private int state;
            private List values;
            private String dataModelKey;
            private boolean printRow;
            private boolean inputRow;
            private boolean emptyRow;
            private String uniqueItemIdentifier;

            public RowDTO(int state, List values, String dataModelKey, boolean printRow, boolean inputRow, String uniqueItemIdentifier, boolean emptyRow) {
                this.state = state;
                this.values = values;
                this.dataModelKey = dataModelKey;
                this.printRow = printRow;
                this.inputRow = inputRow;
                this.emptyRow = emptyRow;
                this.uniqueItemIdentifier = uniqueItemIdentifier;
            }

            public int getState() {
                return this.state;
            }

            public List getValues() {
                return this.values;
            }

            public String getDataModelKey() {
                return this.dataModelKey;
            }

            public boolean isInputRow() {
                return this.inputRow;
            }

            public boolean isEmptyRow() {
                return this.emptyRow;
            }

            public boolean isPrintRow() {
                return this.printRow;
            }

            public String getUniqueItemIdentifier() {
                return this.uniqueItemIdentifier;
            }
        }

        public static class ColumnDTO
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private String title;
            private int type;
            private int width;
            private int alignment;
            private boolean readonly;
            private FontDTO font;
            private FontDTO cellFont;
            private ColorDTO background;
            private AbstractConverter rendererAndInputValidator;
            private Map valuePositions;
            private boolean extraPagesSum;
            private String extraPagesSumKey;
            private int printMode;
            private boolean inputColumn;
            private ExtraPagesSumDTO extraPagesSumPos;
            private boolean submitOnChange;
            private boolean autoWidthOnFocus;
            private String uniqueItemIdentifier;
            private String shortHelpKey;

            public ColumnDTO(String title, int type, int width, int alignment, boolean readonly, FontDTO font, ColorDTO background, AbstractConverter rendererAndInputValidator, Map valuePositions, boolean extraPagesSum, String extraPagesSumKey, int printMode, boolean inputColumn, ExtraPagesSumDTO extraPagesSumPos, boolean submitOnChange, boolean autoWidthOnFocus, String uniqueItemIdentifier, String shortHelpKey, FontDTO cellFont) {
                this.title = title;
                this.type = type;
                this.width = width;
                this.alignment = alignment;
                this.readonly = readonly;
                this.font = font;
                this.background = background;
                this.rendererAndInputValidator = rendererAndInputValidator;
                this.valuePositions = valuePositions;
                this.inputColumn = inputColumn;
                this.printMode = printMode;
                this.extraPagesSum = extraPagesSum;
                this.extraPagesSumKey = extraPagesSumKey;
                this.extraPagesSumPos = extraPagesSumPos;
                this.submitOnChange = submitOnChange;
                this.autoWidthOnFocus = autoWidthOnFocus;
                this.uniqueItemIdentifier = uniqueItemIdentifier;
                this.shortHelpKey = shortHelpKey;
                this.cellFont = cellFont;
            }

            public int getAlignment() {
                return this.alignment;
            }

            public ColorDTO getBackground() {
                return this.background;
            }

            public FontDTO getFont() {
                return this.font;
            }

            public boolean isReadonly() {
                return this.readonly;
            }

            public AbstractConverter getRendererAndInputValidator() {
                return this.rendererAndInputValidator;
            }

            public String getTitle() {
                return this.title;
            }

            public int getType() {
                return this.type;
            }

            public String getShortHelpKey() {
                return this.shortHelpKey;
            }

            public int getWidth() {
                return this.width;
            }

            public int getWidth(float zoom) {
                return Math.round((float)this.width * zoom);
            }

            public Map getValuePositions() {
                return this.valuePositions;
            }

            public boolean isInputColumn() {
                return this.inputColumn;
            }

            public boolean isPrintColumn() {
                return this.printMode != 0;
            }

            public int getPrintMode() {
                return this.printMode;
            }

            public boolean isExtraPagesSum() {
                return this.extraPagesSum;
            }

            public String getExtraPagesSumKey() {
                return this.extraPagesSumKey;
            }

            public ExtraPagesSumDTO getExtraPagesSumPos() {
                return this.extraPagesSumPos;
            }

            public boolean isSubmitOnChange() {
                return this.submitOnChange;
            }

            public boolean isAutoWidthOnFocus() {
                return this.autoWidthOnFocus;
            }

            public String getUniqueItemIdentifier() {
                return this.uniqueItemIdentifier;
            }

            public String getAlignmentString() {
                if (this.alignment == 2) {
                    return "right";
                }
                if (this.alignment == 1) {
                    return "center";
                }
                return "left";
            }

            public FontDTO getDefaultCellFont() {
                return this.cellFont;
            }
        }
    }

    public static class ValueItemDTO
    extends TextItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int type;
        private String dataModelKey;
        private ModelItemDTO modelItem;
        private OptionItemsDTO optionItems;
        private boolean readonly;
        private boolean autoWidthOnFocus;
        private AbstractConverter rendererAndInputValidator;
        private Map valuePositions;
        private boolean submitOnChange;
        private String shortHelpKey;
        private String reRender;

        public ValueItemDTO(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, int type, String dataModelKey, ModelItemDTO modelItem, OptionItemsDTO optionItems, boolean readonly, AbstractConverter rendererAndInputValidator, Map valuePositions, int printMode, boolean submitOnChange, boolean autoWidthOnFocus, String uniqueItemIdentifier, String shortHelpKey, String reRender) {
            super(x, y, width, height, font, bgColor, alignment, printMode, uniqueItemIdentifier);
            this.type = type;
            this.dataModelKey = dataModelKey;
            this.modelItem = modelItem;
            this.optionItems = optionItems;
            this.readonly = readonly;
            this.rendererAndInputValidator = rendererAndInputValidator;
            this.valuePositions = valuePositions;
            this.submitOnChange = submitOnChange;
            this.autoWidthOnFocus = autoWidthOnFocus;
            this.shortHelpKey = shortHelpKey;
            this.reRender = reRender;
        }

        public int getType() {
            return this.type;
        }

        public String getInputType() {
            if (this.type == 0) {
                return "TEXT";
            }
            if (this.type == 4) {
                return "TEXTAREA";
            }
            if (this.type == 1) {
                return "RADIO";
            }
            if (this.type == 2) {
                return "COMBO";
            }
            if (this.type == 3) {
                return "BOOLEAN";
            }
            return "UNKNOWN";
        }

        public String getDataModelKey() {
            return this.dataModelKey;
        }

        public ModelItemDTO getModelItem() {
            return this.modelItem;
        }

        public void setModelItem(ModelItemDTO modelItem) {
            this.modelItem = modelItem;
        }

        public OptionItemsDTO getOptionItems() {
            return this.optionItems;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public AbstractConverter getRendererAndInputValidator() {
            return this.rendererAndInputValidator;
        }

        public Map getValuePositions() {
            return this.valuePositions;
        }

        public String getItemType() {
            return "VALUE";
        }

        public boolean isSubmitOnChange() {
            return this.submitOnChange;
        }

        public boolean isAutoWidthOnFocus() {
            return this.autoWidthOnFocus;
        }

        public String getShortHelpKey() {
            return this.shortHelpKey;
        }

        public String getReRender() {
            return this.reRender;
        }
    }

    public static class Barcode2DDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int x;
        private int y;

        public Barcode2DDTO(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    public static class Barcode2DContainerDTO
    extends ItemDTO {
        private static final long serialVersionUID = 1L;
        public static final int MACRO_PDF417 = 1;
        public static final int DVB_SCAN = 2;
        private int errorCorrection;
        private int length;
        private int columns;
        private int rows;
        private int rowHeight;
        private int type;
        private float aspectRatio;
        private byte[] data;
        private byte[] id;
        private byte contentType;
        private List barcodes;

        public Barcode2DContainerDTO(int x, int y, int width, int height, ColorDTO bgColor, byte[] data, List barcodes, int length, int errorCorrection, float aspectRatio, int rowHeight, int type, int columns, int rows, byte[] id, byte contentType, String uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, 1, uniqueItemIdentifier);
            this.data = data;
            this.barcodes = barcodes;
            this.length = length;
            this.errorCorrection = errorCorrection;
            this.aspectRatio = aspectRatio;
            this.rowHeight = rowHeight;
            this.type = type;
            this.rows = rows;
            this.columns = columns;
            this.id = id;
            this.contentType = contentType;
        }

        public byte[] getData() {
            return this.data;
        }

        public List getBarcodes() {
            return this.barcodes;
        }

        public int getLength() {
            return this.length;
        }

        public int getErrorCorrection() {
            return this.errorCorrection;
        }

        public float getAspectRatio() {
            return this.aspectRatio;
        }

        public int getRowHeight() {
            return this.rowHeight;
        }

        public int getType() {
            return this.type;
        }

        public int getColumns() {
            return this.columns;
        }

        public int getRows() {
            return this.rows;
        }

        public byte[] getId() {
            return this.id;
        }

        public String getItemType() {
            return "BARCODE_2D";
        }

        public byte getContentType() {
            return this.contentType;
        }
    }

    public static class Barcode1DDTO
    extends ItemDTO {
        private static final long serialVersionUID = 3616445696228931897L;
        public static final int CODE39 = 1;
        public static final int CODE128 = 2;
        private String data;
        private int type;
        private int barHeight;
        private int textSize;
        private float minBarWidth;
        private float relBarWidth;

        public Barcode1DDTO(int x, int y, int width, int height, ColorDTO bgColor, int barHeight, float minBarWidth, float relBarWidth, int textSize, String data, int type, int printMode, String uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            this.data = data;
            this.type = type;
            this.barHeight = barHeight;
            this.minBarWidth = minBarWidth;
            this.textSize = textSize;
            this.relBarWidth = relBarWidth;
        }

        public String getData() {
            return this.data;
        }

        public int getType() {
            return this.type;
        }

        public int getBarHeight() {
            return this.barHeight;
        }

        public int getTextSize() {
            return this.textSize;
        }

        public float getMinBarWidth() {
            return this.minBarWidth;
        }

        public float getRelBarWidth() {
            return this.relBarWidth;
        }

        public String getItemType() {
            return "BARCODE";
        }
    }

    public static class ListDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List rows;
        private FontDTO font;
        private int rowHeight;

        public ListDTO(int x, int y, int width, int height, int rowHeight, FontDTO font, ColorDTO bgColor, List rows, int printMode, String uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            this.rows = rows;
            this.font = font;
            this.rowHeight = rowHeight;
        }

        public FontDTO getFont() {
            return this.font;
        }

        public List getRows() {
            return this.rows;
        }

        public int getRowHeight() {
            return this.rowHeight;
        }

        public String getItemType() {
            return "LIST";
        }

        public static class LabelRowDTO
        extends RowDTO {
            private static final long serialVersionUID = 1L;
            private String key;
            private List labelAddOns;

            public LabelRowDTO(String key, List labelAddOns) {
                this.key = key;
                this.labelAddOns = labelAddOns;
            }

            public String getKey() {
                return this.key;
            }

            public List getLabelAddOns() {
                return this.labelAddOns;
            }

            public String getText(LocalizationHelper localizationHelper) {
                return ExpertDisplayInfoDTO.getLabelText(this.key, this.labelAddOns, localizationHelper);
            }
        }

        public static class ValueRowDTO
        extends RowDTO {
            private static final long serialVersionUID = 1L;
            private ModelItemDTO modelItem;
            private AbstractConverter converter;
            private OptionItemsDTO optionItems;

            public ValueRowDTO(ModelItemDTO item, AbstractConverter converter, OptionItemsDTO optionItems) {
                this.converter = converter;
                this.modelItem = item;
                this.optionItems = optionItems;
            }

            public AbstractConverter getConverter() {
                return this.converter;
            }

            public ModelItemDTO getModelItem() {
                return this.modelItem;
            }

            public OptionItemsDTO getOptionItems() {
                return this.optionItems;
            }
        }

        public static abstract class RowDTO
        implements Serializable {
            private static final long serialVersionUID = 1L;
        }
    }

    public static class WizardLinkDTO
    extends LabelDTO {
        private static final long serialVersionUID = 1L;
        private String wizardDmk;
        private int state;

        public WizardLinkDTO(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, String key, List labelAddOns, String wizardDmk, int state, String uniqueItemIdentifier) {
            super(x, y, width, height, font, bgColor, alignment, key, labelAddOns, 0, uniqueItemIdentifier);
            this.wizardDmk = wizardDmk;
            this.state = state;
        }

        public String getWizardDmk() {
            return this.wizardDmk;
        }

        public int getState() {
            return this.state;
        }

        public String getItemType() {
            return "WIZARDLINK";
        }
    }

    public static class LabelDTO
    extends TextItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String key;
        private List labelAddOns;
        private String toString;

        public LabelDTO(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, String key, List labelAddOns, int printMode, String uniqueItemIdentifier) {
            super(x, y, width, height, font, bgColor, alignment, printMode, uniqueItemIdentifier);
            this.key = key;
            this.labelAddOns = labelAddOns;
        }

        public String getKey() {
            return this.key;
        }

        public String getText(LocalizationHelper localizationHelper) {
            return ExpertDisplayInfoDTO.getLabelText(this.key, this.labelAddOns, localizationHelper);
        }

        public String getItemType() {
            return "LABEL";
        }

        public List getLabelAddOns() {
            return this.labelAddOns;
        }

        public String toString() {
            if (this.toString == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.key);
                if (this.labelAddOns != null && this.labelAddOns.size() > 0) {
                    sb.append(" {");
                    Iterator it = this.labelAddOns.iterator();
                    while (it.hasNext()) {
                        LabelAddOnDTO element = (LabelAddOnDTO)it.next();
                        sb.append(element.toString());
                        sb.append(",");
                    }
                    sb.append("}");
                }
                this.toString = sb.toString();
            }
            return this.toString;
        }

        public static class LabelAddOnDTO
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private Object value;
            private AbstractConverter rendererAndInputValidator;
            private OptionItemsDTO optionItems;

            public LabelAddOnDTO(Object value, AbstractConverter rendererAndInputValidator, OptionItemsDTO optionItems) {
                this.value = value;
                this.rendererAndInputValidator = rendererAndInputValidator;
                this.optionItems = optionItems;
            }

            public Object getValue() {
                return this.value;
            }

            public OptionItemsDTO getOptionItems() {
                return this.optionItems;
            }

            public AbstractConverter getRendererAndInputValidator() {
                return this.rendererAndInputValidator;
            }

            public String toString() {
                if (this.value == null) {
                    return "";
                }
                return this.value.toString();
            }
        }
    }

    public static class RectangleDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ColorDTO borderColor;
        private float borderWidth;

        public RectangleDTO(int x, int y, int width, int height, ColorDTO bgColor, ColorDTO borderColor, float borderWidth, int printMode, String uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            this.borderWidth = borderWidth;
            this.borderColor = borderColor;
        }

        public ColorDTO getBorderColor() {
            return this.borderColor;
        }

        public float getBorderWidth() {
            return this.borderWidth;
        }

        public String getItemType() {
            return "RECTANGLE";
        }
    }

    public static abstract class TextItemDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private FontDTO font;
        private int alignment;

        public TextItemDTO(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, int printMode, String uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            this.font = font;
            this.alignment = alignment;
        }

        public FontDTO getFont() {
            return this.font;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public String getAlignmentString() {
            if (this.alignment == 2) {
                return "right";
            }
            if (this.alignment == 1) {
                return "center";
            }
            return "left";
        }
    }

    public static class ButtonDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String commandDmk;
        private String valueDmk;
        private String key;
        private String icon;
        private String uri;
        private ModelItemDTO commandItem;
        private int state;
        private Collection messages;
        private String target;
        private String reRender;

        public ButtonDTO(int x, int y, int width, int height, ColorDTO bgColor, String commandDmk, String valueDmk, String key, String icon, String uri, int state, ModelItemDTO commandItem, String uniqueItemIdentifier, Collection messages, String target, String reRender) {
            super(x, y, width, height, bgColor, 0, uniqueItemIdentifier);
            this.commandDmk = commandDmk;
            this.valueDmk = valueDmk;
            this.key = key;
            this.icon = icon;
            this.uri = uri;
            this.state = state;
            this.commandItem = commandItem;
            this.messages = messages == null ? Collections.EMPTY_LIST : messages;
            this.target = target;
            this.reRender = reRender;
        }

        public String getCommandDmk() {
            return this.commandDmk;
        }

        public String getValueDmk() {
            return this.valueDmk;
        }

        public String getKey() {
            return this.key;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getUri() {
            return this.uri;
        }

        public int getState() {
            return this.state;
        }

        public String getItemType() {
            return "BUTTON";
        }

        public ModelItemDTO getCommandItem() {
            return this.commandItem;
        }

        public Collection getMessages() {
            return this.messages;
        }

        public String getTarget() {
            return this.target;
        }

        public String getReRender() {
            return this.reRender;
        }
    }

    public static class ImageDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String fileName;
        private int page;

        public ImageDTO(int x, int y, int width, int height, ColorDTO bgColor, String fileName, int printMode, String uniqueItemIdentifier) {
            this(x, y, width, height, bgColor, fileName, 1, printMode, uniqueItemIdentifier);
            this.fileName = fileName;
        }

        public ImageDTO(int x, int y, int width, int height, ColorDTO bgColor, String fileName, int page, int printMode, String uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            this.fileName = fileName;
            this.page = page;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getPage() {
            return this.page;
        }

        public String getItemType() {
            return "IMAGE";
        }
    }

    public static abstract class ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int x;
        private int y;
        private int width;
        private int height;
        private ColorDTO bgColor;
        private int printMode;
        private String uniqueItemIdentifier;

        public ItemDTO(int x, int y, int width, int height, ColorDTO bgColor, int printMode, String uniqueItemIdentifier) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.bgColor = bgColor;
            this.printMode = printMode;
            this.uniqueItemIdentifier = uniqueItemIdentifier;
        }

        public int getX() {
            return this.x;
        }

        public int getX(float zoom) {
            return Math.round((float)this.x * zoom);
        }

        public int getY() {
            return this.y;
        }

        public int getY(float zoom) {
            return Math.round((float)this.y * zoom);
        }

        public int getWidth() {
            return this.width;
        }

        public int getWidth(float zoom) {
            return Math.round((float)this.width * zoom);
        }

        public int getHeight() {
            return this.height;
        }

        public int getHeight(float zoom) {
            return Math.round((float)this.height * zoom);
        }

        public ColorDTO getBgColor() {
            return this.bgColor;
        }

        public int getPrintMode() {
            return this.printMode;
        }

        public String getUniqueItemIdentifier() {
            return this.uniqueItemIdentifier;
        }

        public abstract String getItemType();
    }

    public static class PageSettingsDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int width;
        private int height;
        private int marginTop;
        private int marginBottom;
        private int marginLeft;
        private int marginRight;

        public PageSettingsDTO(int width, int height, int marginTop, int marginBottom, int marginLeft, int marginRight) {
            this.width = width;
            this.height = height;
            this.marginTop = marginTop;
            this.marginBottom = marginBottom;
            this.marginLeft = marginLeft;
            this.marginRight = marginRight;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getMarginTop() {
            return this.marginTop;
        }

        public int getMarginBottom() {
            return this.marginBottom;
        }

        public int getMarginLeft() {
            return this.marginLeft;
        }

        public int getMarginRight() {
            return this.marginRight;
        }
    }
}

