/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.tools;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TmoVersion
implements Comparable {
    private List versions = new LinkedList();
    private String filenameWithoutVersion;
    private boolean isSnapshot = false;
    private boolean isLatestLocalBuild = false;
    private static final String PATTERN = "([^-]+)[-]{1,1}([0-9]+)[.]?([0-9]+)[.]?([0-9]+)[^0-9]*|([^0-9]+)(-{1,1}[^0-9]*)";
    private static final String LATESTLOCALBUILD = "localbuild";

    public TmoVersion(String filename) {
        this.versions = this.parseVersion(filename);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = this.versions.iterator();
        while (iterator.hasNext()) {
            Integer element = (Integer)iterator.next();
            sb.append(element).append(".");
        }
        return sb.toString();
    }

    public int compareTo(Object arg0) {
        TmoVersion that = (TmoVersion)arg0;
        if (this.versions.size() == 0 && !this.isLatestLocalBuild && !that.isLatestLocalBuild) {
            return -1;
        }
        if (that.versions.size() == 0 && !that.isLatestLocalBuild) {
            return 1;
        }
        Iterator itThis = this.versions.iterator();
        Iterator itThat = that.versions.iterator();
        while (itThis.hasNext() && itThat.hasNext()) {
            Integer sThat;
            Integer sThis = (Integer)itThis.next();
            int result = sThis.compareTo(sThat = (Integer)itThat.next());
            if (result == 0) continue;
            return result;
        }
        if (this.isSnapshot && !that.isSnapshot) {
            return -1;
        }
        if (!this.isSnapshot && that.isSnapshot) {
            return 1;
        }
        if (this.isLatestLocalBuild && !that.isLatestLocalBuild()) {
            return 1;
        }
        if (!this.isLatestLocalBuild && that.isLatestLocalBuild()) {
            return -1;
        }
        return 0;
    }

    public List parseVersion(String filename) {
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(filename);
        LinkedList<Integer> result = new LinkedList<Integer>();
        if (matcher.matches()) {
            int groups = matcher.groupCount();
            this.filenameWithoutVersion = matcher.group(1);
            this.isLatestLocalBuild = filename.toLowerCase().contains(LATESTLOCALBUILD);
            if (!this.isLatestLocalBuild) {
                for (int i = 2; i <= groups - 2; ++i) {
                    Integer version = Integer.valueOf(matcher.group(i));
                    result.add(version);
                }
                this.isSnapshot = filename.endsWith("-SNAPSHOT");
            } else {
                this.filenameWithoutVersion = matcher.group(5);
            }
        }
        return result;
    }

    public static boolean isValidFilename(String filename) {
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(filename);
        return matcher.matches();
    }

    public String getFilenameWithoutVersion() {
        return this.filenameWithoutVersion;
    }

    public String getFileVersion() {
        String fileVersion = "";
        for (int i = 0; i < this.versions.size(); ++i) {
            fileVersion = fileVersion + this.versions.get(i).toString();
            if (i == this.versions.size() - 1) continue;
            fileVersion = fileVersion + ".";
        }
        return fileVersion;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public boolean isLatestLocalBuild() {
        return this.isLatestLocalBuild;
    }
}

