/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.tools;

import ch.dvbern.tax.common.transfer.ejb.TmoAdminFacadeHome;
import ch.dvbern.tax.common.transfer.ejb.TmoAdminFacadeRemote;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.log4j.Logger;

public class ModelDeployerAntTaskEjb2 {
    private static ModelDeployerAntTaskEjb2 modelDeployer = null;
    private static final String EJB_TMO_ADMIN_FACADE = "/ejb/TmoAdminFacade";
    private static final Logger logger = Logger.getLogger((Class)ModelDeployerAntTaskEjb2.class);
    private String adminFacadejndiName;
    private String modelPath = "target/model";
    private String adminUser;
    private String adminPassword;

    private ModelDeployerAntTaskEjb2() {
    }

    public static ModelDeployerAntTaskEjb2 getInstance() {
        if (modelDeployer == null) {
            modelDeployer = new ModelDeployerAntTaskEjb2();
        }
        return modelDeployer;
    }

    private void deployModel(String version, String modelname) throws Exception {
        String filename = modelname + "-" + version + ".xml";
        this.getAdminFacade(this.getEnv()).uploadTmoModel(this.getTmoModel(filename), filename);
    }

    private void deployResources(Locale locale, String resourcesPath, String version) throws Exception {
        this.deployResources(locale, resourcesPath, null, version);
    }

    private void deployResources(Locale locale, String resourcesPath, String variant, String version) throws Exception {
        StringBuffer filenameWithPath = new StringBuffer(resourcesPath);
        if (variant != null) {
            filenameWithPath.append("_");
            filenameWithPath.append(variant);
        }
        filenameWithPath.append("_");
        filenameWithPath.append(locale.getLanguage());
        filenameWithPath.append(".properties");
        String filename = new File(filenameWithPath.toString()).getName();
        String key = filename.substring(0, filename.indexOf(".properties"));
        String filenameWithVersion = key + "-" + version + ".properties";
        this.getAdminFacade(this.getEnv()).setResources(key, this.getResources(filenameWithPath.toString()), filenameWithVersion);
    }

    private TmoAdminFacadeRemote getAdminFacade(Hashtable env) throws Exception {
        InitialContext initialContext = new InitialContext(env);
        Object objRef = initialContext.lookup(this.adminFacadejndiName);
        logger.info((Object)("looking up: " + this.adminFacadejndiName));
        TmoAdminFacadeHome home = (TmoAdminFacadeHome)PortableRemoteObject.narrow((Object)objRef, (Class)TmoAdminFacadeHome.class);
        return home.create();
    }

    private Hashtable getEnv() {
        Properties properties = new Properties();
        properties.setProperty("java.naming.factory.initial", "org.jboss.security.jndi.JndiLoginInitialContextFactory");
        properties.setProperty("java.naming.provider.url", "jnp://localhost:1099");
        properties.setProperty("java.naming.factory.url.pkgs", "org.jnp.interfaces.NamingContextFactory");
        properties.setProperty("java.naming.security.principal", this.adminUser);
        properties.setProperty("java.naming.security.credentials", this.adminPassword);
        return properties;
    }

    private String getTmoModel(String filename) throws IOException {
        return this.getModelContent(this.modelPath + File.separator + filename);
    }

    private void setJndiPrefix(String jndiPrefix) {
        this.adminFacadejndiName = jndiPrefix + EJB_TMO_ADMIN_FACADE;
    }

    private void setAdminUser(String adminUser) {
        this.adminUser = adminUser;
    }

    private void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    private String getModelContent(String filePath) throws IOException {
        GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(new FileInputStream(filePath)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int read = ((InputStream)is).read(buffer);
        while (read >= 0) {
            baos.write(buffer, 0, read);
            read = ((InputStream)is).read(buffer);
        }
        baos.close();
        ((InputStream)is).close();
        String xmlStructure = new String(baos.toByteArray());
        return xmlStructure;
    }

    private Properties getResources(String filePath) throws IOException {
        FileInputStream fis = new FileInputStream(filePath);
        BufferedInputStream bis = new BufferedInputStream(fis);
        Properties props = new Properties();
        props.load(bis);
        fis.close();
        bis.close();
        return props;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            logger.info((Object)"usage:");
            logger.info((Object)"args[0]: admin user");
            logger.info((Object)"args[1]: admin pwd");
            logger.info((Object)"args[2]: version");
            logger.info((Object)"args[3]: model name");
            logger.info((Object)"args[4]: jndi name");
            logger.info((Object)"args[5]: resources path");
            logger.info((Object)"args[6-x]: resources variant");
            return;
        }
        ModelDeployerAntTaskEjb2 deployer = new ModelDeployerAntTaskEjb2();
        String adminUser = args[0];
        deployer.setAdminUser(adminUser);
        String adminPassword = args[1];
        deployer.setAdminPassword(adminPassword);
        String version = args[2];
        String modelname = args[3];
        String jndiPrefix = args[4];
        deployer.setJndiPrefix(jndiPrefix);
        deployer.deployModel(version, modelname);
        String resourcesPath = args[5];
        deployer.deployResources(Locale.GERMAN, resourcesPath, version);
        deployer.deployResources(Locale.FRENCH, resourcesPath, version);
        if (args.length > 6) {
            for (int i = 6; i < args.length; ++i) {
                String variant = args[i];
                deployer.deployResources(Locale.GERMAN, resourcesPath, variant, version);
                deployer.deployResources(Locale.FRENCH, resourcesPath, variant, version);
            }
        }
    }
}

