/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.tools;

import ch.dvbern.tax.common.presentation.web.admin.util.ActionHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.GZIPInputStream;

public class ModelDeployer {
    private static ModelDeployer modelDeployer = null;

    private ModelDeployer() {
    }

    public static ModelDeployer getInstance() {
        if (modelDeployer == null) {
            modelDeployer = new ModelDeployer();
        }
        return modelDeployer;
    }

    public void deployModel(File file, String fileName) throws Exception {
        ActionHelper.getTmoAdmin().uploadTmoModel(this.getModelContent(file), fileName);
    }

    public void deployResources(String key, File file, String filename) throws Exception {
        ActionHelper.getTmoAdmin().setResources(key, this.getResources(file), filename);
    }

    public void deployFile(String key, File file, String filename) throws Exception {
        ActionHelper.getTmoAdmin().setFile(null, key, this.getFileContent(file), filename);
    }

    private String getModelContent(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(fis));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int read = ((InputStream)is).read(buffer);
        while (read >= 0) {
            baos.write(buffer, 0, read);
            read = ((InputStream)is).read(buffer);
        }
        baos.close();
        ((InputStream)is).close();
        String xmlStructure = new String(baos.toByteArray());
        return xmlStructure;
    }

    private Properties getResources(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        Properties props = new Properties();
        props.load(bis);
        fis.close();
        bis.close();
        return props;
    }

    private String getFileContent(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int read = fis.read(buffer);
        while (read >= 0) {
            baos.write(buffer, 0, read);
            read = fis.read(buffer);
        }
        baos.close();
        fis.close();
        String fileContent = new String(baos.toByteArray());
        return fileContent;
    }
}

