/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.tools;

import ch.dvbern.tax.common.presentation.bd.TmoAdmin;
import ch.dvbern.tax.common.presentation.tools.ModelDeployer;
import ch.dvbern.tax.common.presentation.tools.TmoVersion;
import ch.dvbern.tax.common.presentation.web.admin.util.ActionHelper;
import com.jamonapi.proxy.MonProxyFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class ConfigurationDeployer {
    private static ConfigurationDeployer configurationDeployer;
    private static final String CONFIG_PATH = "/configuration/";
    private static final Logger logger;

    private ConfigurationDeployer() {
    }

    public static ConfigurationDeployer getInstance() {
        if (configurationDeployer == null) {
            configurationDeployer = new ConfigurationDeployer();
        }
        return configurationDeployer;
    }

    public void checkFileVersions() throws Exception {
        File[] files = this.getConfigFiles(ConfigurationDeployer.class, CONFIG_PATH);
        if (files != null) {
            ModelDeployer deployer = ModelDeployer.getInstance();
            TmoAdmin tmoAdmin = (TmoAdmin)MonProxyFactory.monitor((Object)ActionHelper.getTmoAdmin(), (Class)TmoAdmin.class);
            for (int i = 0; i < files.length; ++i) {
                if (!this.checkIfNewerFileExists(files[i].getName(), tmoAdmin)) continue;
                this.updateConfigurationFile(deployer, files[i], files[i].getName());
            }
        }
    }

    private File[] getConfigFiles(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getResource(path);
        if (dirURL != null) {
            if (dirURL.getProtocol().equals("jar")) {
                return this.extractFromJar(dirURL);
            }
            return this.extractFromFileSystem(dirURL);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] extractFromJar(URL dirURL) throws IOException {
        JarEntry jarEntry = null;
        String fullName = null;
        InputStream inStream = null;
        HashSet<File> result = new HashSet<File>();
        FileOutputStream fos = null;
        File file = null;
        String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
        JarFile jarFile = new JarFile(jarPath);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                jarEntry = entries.nextElement();
                fullName = jarEntry.getName();
                if (!fullName.startsWith("configuration/") || fullName.endsWith("/")) continue;
                inStream = jarFile.getInputStream(jarEntry);
                logger.debug((Object)("extract file: " + fullName));
                file = new File(System.getProperty("java.io.tmpdir"), fullName.substring(14));
                logger.debug((Object)("to tmp file: " + file.getAbsolutePath()));
                fos = new FileOutputStream(file);
                int i = 0;
                while ((i = inStream.read()) != -1) {
                    fos.write(i);
                }
                result.add(file);
            }
        }
        finally {
            jarFile.close();
            if (inStream != null) {
                inStream.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        return result.toArray(new File[result.size()]);
    }

    private File[] extractFromFileSystem(URL dirURL) throws IOException {
        File f;
        HashSet<File> result = new HashSet<File>();
        if (dirURL != null && (f = new File(dirURL.getFile())).isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                result.add(file);
            }
        }
        return result.toArray(new File[result.size()]);
    }

    public boolean checkIfNewerFileExists(String fileName, TmoAdmin tmoAdmin) throws Exception {
        TmoVersion versionApp = new TmoVersion(fileName);
        if (!TmoVersion.isValidFilename(fileName)) {
            logger.debug((Object)("invalid filename: " + fileName));
            return false;
        }
        String filenameWithoutVersion = versionApp.getFilenameWithoutVersion();
        logger.debug((Object)("filename: " + filenameWithoutVersion));
        logger.debug((Object)("version in ear: " + versionApp));
        String filenameDB = tmoAdmin.getConfigurationFilename(filenameWithoutVersion);
        if (filenameDB == null) {
            return true;
        }
        TmoVersion versionDB = new TmoVersion(filenameDB);
        if (!TmoVersion.isValidFilename(filenameDB)) {
            logger.debug((Object)("invalid filename: " + filenameDB));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Version in App: " + versionApp + "; version in DB: " + versionDB));
        }
        if (versionApp.compareTo(versionDB) >= 0) {
            logger.debug((Object)("File aus App muss genommen werden: " + filenameWithoutVersion));
            return true;
        }
        logger.debug((Object)("Keine Aktualisierung notwendig f\u00fcr " + filenameWithoutVersion));
        return false;
    }

    private void updateConfigurationFile(ModelDeployer deployer, File file, String filename) throws Exception {
        if (filename.contains("model")) {
            deployer.deployModel(file, filename);
        } else if (filename.contains("resource")) {
            TmoVersion versionApp = new TmoVersion(filename);
            deployer.deployResources(versionApp.getFilenameWithoutVersion(), file, filename);
        } else {
            TmoVersion versionApp = new TmoVersion(filename);
            deployer.deployFile(versionApp.getFilenameWithoutVersion(), file, filename);
        }
    }

    static {
        logger = Logger.getLogger((Class)ConfigurationDeployer.class);
    }
}

