/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.LabelAddOnHelper;
import java.text.Collator;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class WizardTableRowComparator
implements Comparator {
    private static final Logger logger = Logger.getLogger((Class)WizardTableRowComparator.class);
    private boolean asc = true;
    private int column = 0;
    private LocalizationHelper locHelper = null;
    private Collator collator = null;

    public WizardTableRowComparator(int column, boolean asc, LocalizationHelper locHelper) {
        this.column = column;
        this.asc = asc;
        this.locHelper = locHelper;
        try {
            this.collator = Collator.getInstance(locHelper.getCurrentLocale());
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new RuntimeException(e);
        }
    }

    public int compare(Object o1, Object o2) {
        WizardDisplayInfoDTO.RowItemDTO row1 = (WizardDisplayInfoDTO.RowItemDTO)o1;
        WizardDisplayInfoDTO.RowItemDTO row2 = (WizardDisplayInfoDTO.RowItemDTO)o2;
        int ret = this.compareAsc(row1, row2);
        return this.asc ? ret : -1 * ret;
    }

    private int compareAsc(WizardDisplayInfoDTO.RowItemDTO row1, WizardDisplayInfoDTO.RowItemDTO row2) {
        Comparable value1 = this.getComparableValue(row1, this.column);
        Comparable value2 = this.getComparableValue(row2, this.column);
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (value1 instanceof String && value2 instanceof String) {
            return this.compareAsc((String)((Object)value1), (String)((Object)value2));
        }
        return this.compareAsc(value1, value2);
    }

    private Comparable getComparableValue(WizardDisplayInfoDTO.RowItemDTO row, int col) {
        Object item = row.getCols().get(col);
        if (item instanceof WizardDisplayInfoDTO.ItemItemDTO) {
            return this.getItemValue((WizardDisplayInfoDTO.ItemItemDTO)item);
        }
        if (item instanceof WizardDisplayInfoDTO.LabelItemDTO) {
            WizardDisplayInfoDTO.LabelItemDTO labelItemDTO = (WizardDisplayInfoDTO.LabelItemDTO)item;
            try {
                Object[] args = LabelAddOnHelper.getReplacements(labelItemDTO.getLabelAddOns(), this.locHelper);
                return this.locHelper.translate(labelItemDTO.getName().toString(), args);
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                logger.warn((Object)"translation failed", (Throwable)e);
                return "";
            }
        }
        if (item instanceof WizardDisplayInfoDTO.StateItemDTO) {
            return new Integer(((WizardDisplayInfoDTO.StateItemDTO)item).getState());
        }
        return null;
    }

    private Comparable getItemValue(WizardDisplayInfoDTO.ItemItemDTO item) {
        Object value = item.getValue();
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        AbstractConverter conv = item.getRendererAndInputValidator();
        if (conv == null) {
            return value.toString();
        }
        return conv.getRenderedValue(value, item.getReadonly(), item.getOptionItems(), this.locHelper);
    }

    private int compareAsc(String value1, String value2) {
        return this.collator.compare(value1, value2);
    }

    private int compareAsc(Comparable value1, Comparable value2) {
        if (value1.getClass().equals(value2.getClass())) {
            return value1.compareTo(value2);
        }
        if (value1 instanceof Number && value2 instanceof Number) {
            Double d1 = new Double(((Number)((Object)value1)).doubleValue());
            Double d2 = new Double(((Number)((Object)value2)).doubleValue());
            return d1.compareTo(d2);
        }
        return this.compareAsc(value1.toString(), value2.toString());
    }
}

