/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import ch.dvbern.tax.common.transfer.failure.TaxFileCorruptedException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.log4j.Logger;

public class TaxFileUtil {
    public static final String MODEL_ZIP_ENTRY = "dvb-tax-model-12345678909876543210";
    private static final Logger log = Logger.getLogger((Class)TaxFileUtil.class);
    private static final byte[] HEADER = new byte[]{100, 118, 98, 101, 114, 110, 45, 116, 97, 120, 0, 0, 0};
    private static final byte VERSION_NO_COMPRESSION = 1;
    private static final byte VERSION_GZIP = 2;
    private static byte[] salt = new byte[]{-102, -71, -116, 98, 86, 83, -93, -109};
    private static final int iterationCount = 31;
    private static final String ALGORITHM = "PBEWithMD5AndDES";

    private TaxFileUtil() {
    }

    static Cipher createCipher() {
        try {
            return Cipher.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ApplicationException("can't initialize cipher", e);
        }
        catch (NoSuchPaddingException e) {
            throw new ApplicationException("can't initialize cipher", e);
        }
    }

    static SecretKey createSecretKey(String pw) {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(ALGORITHM);
            PBEKeySpec spec = new PBEKeySpec(pw.toCharArray(), salt, 31);
            return skf.generateSecret(spec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ApplicationException("can't initialize secret key", e);
        }
        catch (InvalidKeySpecException e) {
            throw new ApplicationException("can't initialize secret key", e);
        }
    }

    static AlgorithmParameterSpec createAlgorithmParamSpec(String pw) {
        PBEKeySpec spec = new PBEKeySpec(pw.toCharArray(), salt, 31);
        return new PBEParameterSpec(spec.getSalt(), spec.getIterationCount());
    }

    public static Map read(InputStream is, String password) throws InvalidAuthenticationException {
        try {
            is = new BufferedInputStream(is);
            is.mark(500);
            return TaxFileUtil.read(is, TaxFileUtil.createCipher(), TaxFileUtil.createAlgorithmParamSpec(password), TaxFileUtil.createSecretKey(password));
        }
        catch (ApplicationException ae) {
            try {
                is.reset();
                ZipInputStream zis = new ZipInputStream(is);
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    if (MODEL_ZIP_ENTRY.equals(ze.getName())) {
                        return TaxFileUtil.read(zis, TaxFileUtil.createCipher(), TaxFileUtil.createAlgorithmParamSpec(password), TaxFileUtil.createSecretKey(password));
                    }
                    ze = zis.getNextEntry();
                }
            }
            catch (IOException e) {
                log.debug((Object)"stream is not zipped", (Throwable)e);
            }
            throw ae;
        }
    }

    static Map read(InputStream is, Cipher cipher, AlgorithmParameterSpec paramSpec, SecretKey secretKey) throws InvalidAuthenticationException {
        try {
            cipher.init(2, (Key)secretKey, paramSpec);
            for (int i = 0; i < HEADER.length; ++i) {
                if (HEADER[i] == is.read()) continue;
                throw new ApplicationException("invalid header");
            }
            int version = is.read();
            is = new CipherInputStream(is, cipher);
            switch (version) {
                case 1: {
                    break;
                }
                case 2: {
                    is = new GZIPInputStream(is);
                    break;
                }
                default: {
                    throw new ApplicationException("invalid version");
                }
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            return (Map)ois.readObject();
        }
        catch (Exception e) {
            if (e instanceof StreamCorruptedException) {
                throw new TaxFileCorruptedException(e);
            }
            throw new ApplicationException("read failed", e);
        }
    }

    public static void write(OutputStream os, Map dataModel, String password) {
        TaxFileUtil.write(os, dataModel, TaxFileUtil.createCipher(), TaxFileUtil.createAlgorithmParamSpec(password), TaxFileUtil.createSecretKey(password));
    }

    static void write(OutputStream os, Map dataModel, Cipher cipher, AlgorithmParameterSpec paramSpec, SecretKey secretKey) {
        try {
            os.write(HEADER);
            os.write(2);
            cipher.init(1, (Key)secretKey, paramSpec);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new CipherOutputStream(baos, cipher)));
            oos.writeObject(dataModel);
            oos.close();
            os.write(baos.toByteArray());
        }
        catch (IOException e) {
            throw new ApplicationException("save failed", e);
        }
        catch (InvalidKeyException e) {
            throw new ApplicationException("save failed", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ApplicationException("save failed", e);
        }
    }
}

