/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.presentation.common.util.IOUtil;
import ch.dvbern.tax.common.presentation.common.util.TaxFileAttachment;
import ch.dvbern.tax.common.presentation.common.util.TaxFileUtil;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.InvalidAuthenticationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;

public class TaxFile {
    private static final Logger log = Logger.getLogger((Class)TaxFile.class);
    private final Cipher cipher = TaxFileUtil.createCipher();
    private AlgorithmParameterSpec paramSpec;
    private SecretKey secretKey;
    private File file;
    private String password;

    public TaxFile(File file, String password) {
        this.setFile(file);
        this.setPassword(password);
    }

    public File getFile() {
        return this.file;
    }

    private void setFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        this.file = file;
    }

    public void setPassword(String pw) {
        if (pw == null) {
            pw = "";
        }
        if (pw.equals(this.password)) {
            return;
        }
        this.secretKey = TaxFileUtil.createSecretKey(pw);
        this.paramSpec = TaxFileUtil.createAlgorithmParamSpec(pw);
        this.password = pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map readModel() throws InvalidAuthenticationException {
        Map map;
        ZipFile zf = null;
        BufferedInputStream is = null;
        try {
            try {
                zf = new ZipFile(this.file);
                ZipEntry ze = zf.getEntry("dvb-tax-model-12345678909876543210");
                if (ze == null) {
                    throw new ApplicationException("TaxFile contains no model");
                }
                is = new BufferedInputStream(zf.getInputStream(ze));
            }
            catch (IOException ioe) {
                log.info((Object)"can't open as zip file. trying to open as an old tax file");
                log.debug((Object)"Exception", (Throwable)ioe);
                is = new BufferedInputStream(new FileInputStream(this.file));
            }
            Cipher ioe = this.cipher;
            synchronized (ioe) {
                map = TaxFileUtil.read(is, this.cipher, this.paramSpec, this.secretKey);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(is);
            IOUtil.closeSilent(zf);
            throw throwable;
        }
        {
            catch (IOException e) {
                throw new ApplicationException("read failed", e);
            }
        }
        IOUtil.closeSilent(is);
        IOUtil.closeSilent(zf);
        return map;
    }

    public void saveModel(Map dataModel) {
        if (dataModel == null) {
            throw new IllegalArgumentException("can't save. dataModel must not be null");
        }
        this.save(null, null, null, dataModel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAttachments() {
        if (!this.file.exists() || this.file.length() == 0L) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TaxFileAttachment> toReturn = new ArrayList<TaxFileAttachment>();
        ZipFile zf = null;
        try {
            zf = new ZipFile(this.file);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                if ("dvb-tax-model-12345678909876543210".equals(ze.getName())) continue;
                TaxFileAttachment att = new TaxFileAttachment(ze.getName(), ze.getComment(), ze.getSize(), this);
                toReturn.add(att);
            }
            Collections.sort(toReturn);
        }
        catch (IOException ioe) {
            try {
                log.info((Object)"can't read zip file entries. probably an old tax file");
                log.debug((Object)"exception", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(zf);
                throw throwable;
            }
            IOUtil.closeSilent(zf);
        }
        IOUtil.closeSilent(zf);
        return toReturn;
    }

    public File getAttachmentFile(TaxFileAttachment attachment) {
        if (attachment == null) {
            throw new NullPointerException("attachment may not be null");
        }
        return this.getAttachmentFile(attachment.getFileName());
    }

    public File getAttachmentFile(String fileName) {
        File file;
        if (fileName == null) {
            throw new NullPointerException("fileName may not be null");
        }
        BufferedInputStream is = null;
        ZipFile zf = null;
        File tmp = null;
        try {
            zf = new ZipFile(this.file);
            ZipEntry ze = zf.getEntry(fileName);
            if (ze == null) {
                File file2 = null;
                return file2;
            }
            String name = ze.getName();
            int pos = name.lastIndexOf(46);
            tmp = pos > 0 ? File.createTempFile(name.substring(0, pos), name.substring(pos)) : File.createTempFile(name, null);
            is = new BufferedInputStream(zf.getInputStream(ze));
            IOUtil.copy((InputStream)is, tmp);
            file = tmp;
            IOUtil.closeSilent(is);
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
        finally {
            IOUtil.closeSilent(is);
            IOUtil.closeSilent(zf);
            IOUtil.deleteOnExitSilent(tmp);
        }
        IOUtil.closeSilent(zf);
        IOUtil.deleteOnExitSilent(tmp);
        return file;
    }

    public void putAttachmentFile(File file, String comment) {
        if (file == null) {
            throw new NullPointerException("file may not be null");
        }
        if ("dvb-tax-model-12345678909876543210".equals(file.getName())) {
            throw new IllegalArgumentException("invalid file name:" + file.getName());
        }
        this.save(null, file, comment, null, null);
    }

    public void removeAttachment(TaxFileAttachment attachment) {
        if (attachment == null) {
            throw new NullPointerException("attachment may not be null");
        }
        this.removeAttachment(attachment.getFileName());
    }

    public void removeAttachment(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("fileName may not be null");
        }
        this.save(fileName, null, null, null, null);
    }

    public void setComment(String fileName, String comment) {
        if (fileName == null) {
            throw new NullPointerException("fileName may not be null");
        }
        this.save(null, null, comment, null, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String toRemove, File toAdd, String comment, Map newModel, String fileForCommentUpdate) {
        ZipOutputStream os = null;
        ZipFile zf = null;
        File tmp = null;
        try {
            ZipEntry ze;
            if (this.getAttachments().size() > 0 || toAdd != null || toRemove != null) {
                tmp = File.createTempFile(this.file.getName(), ".tmp");
            }
            os = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmp == null ? this.file : tmp)));
            if (newModel != null) {
                ze = new ZipEntry("dvb-tax-model-12345678909876543210");
                os.putNextEntry(ze);
                TaxFileUtil.write(os, newModel, this.cipher, this.paramSpec, this.secretKey);
                os.closeEntry();
            }
            if (toAdd != null) {
                ze = new ZipEntry(toAdd.getName());
                ze.setSize(toAdd.length());
                if (comment != null) {
                    ze.setComment(comment);
                }
                os.putNextEntry(ze);
                IOUtil.copy(toAdd, (OutputStream)os);
                os.closeEntry();
            }
            if (tmp != null && this.file.exists() && this.file.length() > 0L) {
                try {
                    zf = new ZipFile(this.file);
                }
                catch (ZipException ze2) {
                    log.info((Object)"can't open the current tax file as a zip file. probably an old tax file.");
                    log.debug((Object)"exception", (Throwable)ze2);
                }
            }
            if (zf != null) {
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    String toAddName;
                    ZipEntry ze3 = entries.nextElement();
                    String string = toAddName = toAdd == null ? null : toAdd.getName();
                    if (ze3.getName().equals(toRemove) || ze3.getName().equals(toAddName) || ze3.getName().equals("dvb-tax-model-12345678909876543210") && newModel != null) continue;
                    if (ze3.getName().equals(fileForCommentUpdate)) {
                        ze3.setComment(comment);
                    }
                    os.putNextEntry(ze3);
                    InputStream is = zf.getInputStream(ze3);
                    try {
                        IOUtil.copy(is, (OutputStream)os);
                    }
                    finally {
                        is.close();
                    }
                    os.closeEntry();
                }
            }
            IOUtil.closeSilent(zf);
            os.close();
            if (tmp != null) {
                IOUtil.copy(tmp, this.file);
            }
        }
        catch (IOException ioe) {
            try {
                throw new ApplicationException("zip file save failed", ioe);
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(os);
                IOUtil.closeSilent(zf);
                IOUtil.deleteSilent(tmp);
                throw throwable;
            }
        }
        IOUtil.closeSilent(os);
        IOUtil.closeSilent(zf);
        IOUtil.deleteSilent(tmp);
    }
}

