/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.presentation.common.util.ExpertTableRowComparator;
import ch.dvbern.tax.common.presentation.common.util.TableSort;
import ch.dvbern.tax.common.presentation.common.util.WizardTableRowComparator;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class TableSortHelper {
    public static void sortTables(Map tableSorts, WizardDisplayInfoDTO diDTO, LocalizationHelper locHelper) {
        if (diDTO == null || diDTO.getFormItemDTO().getChildren() == null) {
            return;
        }
        Iterator it = diDTO.getFormItemDTO().getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof WizardDisplayInfoDTO.TableItemDTO)) continue;
            TableSortHelper.sortTable((WizardDisplayInfoDTO.TableItemDTO)child, locHelper, tableSorts);
        }
    }

    public static void sortTables(Map tableSorts, ExpertDisplayInfoDTO diDTO, LocalizationHelper locHelper) {
        if (diDTO == null) {
            return;
        }
        Iterator it = diDTO.getItems().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof ExpertDisplayInfoDTO.TableDTO)) continue;
            TableSortHelper.sortTable((ExpertDisplayInfoDTO.TableDTO)child, locHelper, tableSorts);
        }
    }

    public static void sortTable(ExpertDisplayInfoDTO.TableDTO table, LocalizationHelper locale, Map sorts) {
        if (table.getAllRows() == null || table.getAllRows().isEmpty()) {
            return;
        }
        TableSort tableSort = (TableSort)sorts.get(table.getLogicModelKey());
        if (tableSort == null || tableSort.getIndex() < 0 || tableSort.getIndex() >= table.getInputColumns().size()) {
            return;
        }
        ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)table.getInputColumns().get(tableSort.getIndex());
        int allColumnsIndex = 0;
        Iterator it = table.getAllColumns().iterator();
        while (it.hasNext() && !it.next().equals(col)) {
            ++allColumnsIndex;
        }
        ExpertTableRowComparator comp = new ExpertTableRowComparator(allColumnsIndex - 1, tableSort.isAsc(), locale, table.getAllColumns());
        Collections.sort(table.getAllRows(), comp);
        Collections.sort(table.getInputRows(), comp);
        Collections.sort(table.getPrintRows(), comp);
    }

    public static void sortTable(WizardDisplayInfoDTO.TableItemDTO table, LocalizationHelper locHelper, Map sorts) {
        if (table.getRows() == null || table.getRows().isEmpty()) {
            return;
        }
        TableSort tableSort = (TableSort)sorts.get(table.getLogicModelKey());
        if (tableSort == null || tableSort.getIndex() < 0 || tableSort.getIndex() >= table.getCntCols()) {
            return;
        }
        WizardTableRowComparator comp = new WizardTableRowComparator(tableSort.getIndex(), tableSort.isAsc(), locHelper);
        Collections.sort(table.getRows(), comp);
    }
}

