/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class CachedImageSource
implements ImageSource {
    private static final Logger log = Logger.getLogger((Class)CachedImageSource.class);
    private final Map hash = new HashMap();
    private final LinkedHashMap hardCache = new LRUCache(50);
    private final ReferenceQueue queue = new ReferenceQueue();

    public byte[] getImage(String name) throws IOException {
        log.debug((Object)("loading image: " + name));
        byte[] image = this.getFromCache(name);
        if (image == null) {
            log.debug((Object)("image not found in cache: " + name));
            image = this.loadImageInternal(name);
            this.addToCache(name, image);
        }
        return image;
    }

    public InputStream getImageAsStream(String name) throws IOException {
        byte[] image = this.getImage(name);
        if (image == null) {
            return null;
        }
        return new ByteArrayInputStream(image);
    }

    protected abstract byte[] loadImageInternal(String var1) throws IOException;

    private byte[] getFromCache(String name) {
        byte[] result = null;
        SoftReference soft_ref = (SoftReference)this.hash.get(name);
        if (soft_ref != null) {
            result = (byte[])soft_ref.get();
            if (result == null) {
                this.hash.remove(name);
            } else {
                this.hardCache.put(name, result);
            }
        }
        return result;
    }

    private void addToCache(String name, byte[] value) {
        this.processQueue();
        this.hash.put(name, new SoftValue(value, name, this.queue));
    }

    private void processQueue() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    private static class LRUCache
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private int maxSize;

        public LRUCache(int maxSize) {
            this.maxSize = maxSize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }
    }

    private static class SoftValue
    extends SoftReference {
        private final Object key;

        private SoftValue(Object k, Object key, ReferenceQueue q) {
            super(k, q);
            this.key = key;
        }
    }
}

