/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.WizardItemPrinter;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.common.transfer.util.LabelAddOnHelper;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class WizardTablePrinter
extends WizardItemPrinter {
    private static final Logger log = Logger.getLogger((Class)WizardTablePrinter.class);
    private WizardDisplayInfoDTO.TableItemDTO tableItemDTO;

    protected void initalize(WizardDisplayInfoDTO.AbstractItemDTO item) {
        this.tableItemDTO = (WizardDisplayInfoDTO.TableItemDTO)item;
    }

    public void print(float xOffset, float yOffset) throws FormRendererException {
        if (this.tableItemDTO.getRows() == null || this.tableItemDTO.getRows().isEmpty()) {
            return;
        }
        PdfPTable table = new PdfPTable(this.tableItemDTO.getColdefs().size());
        table.setWidthPercentage(100.0f);
        table.setHeaderRows(2);
        table.setSpacingAfter(12.0f);
        Object[] args = LabelAddOnHelper.getReplacements(this.tableItemDTO.getLabelAddOns(), this.getLocalizationHelper());
        this.addTableTitle(table, this.translate(this.tableItemDTO.getHeader(), args), this.tableItemDTO.getColdefs().size());
        int[] colwidths = this.getGridArray(this.tableItemDTO.getColdefs());
        Iterator it = this.tableItemDTO.getColdefs().iterator();
        while (it.hasNext()) {
            WizardDisplayInfoDTO.ColDefItemDTO coldefItemDTO = (WizardDisplayInfoDTO.ColDefItemDTO)it.next();
            Object[] argsColdef = LabelAddOnHelper.getReplacements(coldefItemDTO.getHeaderAddOns(), this.getLocalizationHelper());
            this.addTableHeader(table, this.translate(coldefItemDTO.getHeader(), argsColdef), 1);
        }
        try {
            table.setWidths(colwidths);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print section", e);
        }
        List rows = this.tableItemDTO.getRows();
        if (rows != null && rows.size() > 0) {
            Iterator it2 = rows.iterator();
            while (it2.hasNext()) {
                this.printRow(table, (WizardDisplayInfoDTO.RowItemDTO)it2.next());
            }
        }
        try {
            this.getDocument().add((Element)table);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print section", e);
        }
    }

    private void printRow(PdfPTable table, WizardDisplayInfoDTO.RowItemDTO rowItemDTO) throws FormRendererException {
        List cols = rowItemDTO.getCols();
        if (cols != null && cols.size() > 0) {
            Iterator iterCols = rowItemDTO.getCols().iterator();
            while (iterCols.hasNext()) {
                WizardDisplayInfoDTO.AbstractItemDTO element = (WizardDisplayInfoDTO.AbstractItemDTO)iterCols.next();
                if (element instanceof WizardDisplayInfoDTO.ItemItemDTO) {
                    WizardDisplayInfoDTO.ItemItemDTO itemItemDTO = (WizardDisplayInfoDTO.ItemItemDTO)element;
                    String s = this.getText(itemItemDTO);
                    this.addTableCell(table, s, itemItemDTO.getColspan(), itemItemDTO.getAlign());
                    continue;
                }
                if (element instanceof WizardDisplayInfoDTO.LabelItemDTO) {
                    WizardDisplayInfoDTO.LabelItemDTO labelItemDTO = (WizardDisplayInfoDTO.LabelItemDTO)element;
                    this.addTableCell(table, this.getText(labelItemDTO), labelItemDTO.getColspan(), labelItemDTO.getAlign());
                    continue;
                }
                log.warn((Object)("unsupported type in table: " + element.getClass().getName()));
            }
        } else {
            this.addTableCell(table, " ", this.tableItemDTO.getColdefs().size(), "");
        }
    }
}

