/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.WizardItemPrinter;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SectionPrinter
extends WizardItemPrinter {
    private static final Logger logger = Logger.getLogger((Class)SectionPrinter.class);
    private WizardDisplayInfoDTO.SectionItemDTO section;

    protected void initalize(WizardDisplayInfoDTO.AbstractItemDTO item) {
        this.section = (WizardDisplayInfoDTO.SectionItemDTO)item;
    }

    public void print(float xOffset, float yOffset) throws FormRendererException {
        List rows;
        if (12 == this.section.getState()) {
            return;
        }
        int nbrCols = this.section.getColdefs().size();
        PdfPTable table = new PdfPTable(nbrCols);
        table.setWidthPercentage(100.0f);
        table.setHeaderRows(1);
        table.setSpacingAfter(18.0f);
        if (this.section.getHeader() != null) {
            String translatedText;
            String key = this.section.getHeader();
            List args = this.section.getHeaderAddOns();
            try {
                translatedText = args != null ? this.getLocalizationHelper().translate(key, args.toArray()) : this.getLocalizationHelper().translate(key, null);
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                logger.warn((Object)("could not translate: " + key), (Throwable)e);
                translatedText = key;
            }
            this.addTableHeader(table, translatedText, nbrCols);
        }
        try {
            int[] columns = this.getGridArray(this.section.getColdefs());
            table.setWidths(columns);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print section", e);
        }
        if (this.section.getHeaders() != null && !this.section.getHeaders().isEmpty()) {
            Iterator it = this.section.getHeaders().iterator();
            while (it.hasNext()) {
                String translatedText;
                WizardDisplayInfoDTO.HeaderItemDTO header = (WizardDisplayInfoDTO.HeaderItemDTO)it.next();
                String key = header.getName().toString();
                try {
                    translatedText = header.getText(this.getLocalizationHelper());
                }
                catch (FormRendererException e) {
                    logger.error((Object)("could not retrieve header-addons for header " + key), (Throwable)e);
                    translatedText = key;
                }
                this.addTableHeader(table, translatedText, header.getColspan());
            }
        }
        if ((rows = this.section.getRows()) != null && rows.size() > 0) {
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                WizardDisplayInfoDTO.RowItemDTO rowItemDTO = (WizardDisplayInfoDTO.RowItemDTO)it.next();
                if (12 == rowItemDTO.getState()) continue;
                this.printRow(table, rowItemDTO);
            }
        }
        try {
            this.getDocument().add((Element)table);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print section", e);
        }
    }

    private void printRow(PdfPTable table, WizardDisplayInfoDTO.RowItemDTO rowItemDTO) throws FormRendererException {
        List cols = rowItemDTO.getCols();
        if (cols != null && cols.size() > 0) {
            Iterator it = cols.iterator();
            while (it.hasNext()) {
                WizardDisplayInfoDTO.AbstractItemDTO element = (WizardDisplayInfoDTO.AbstractItemDTO)it.next();
                if (element instanceof WizardDisplayInfoDTO.LabelItemDTO) {
                    WizardDisplayInfoDTO.LabelItemDTO labelItemDTO = (WizardDisplayInfoDTO.LabelItemDTO)element;
                    this.addTableCell(table, this.getText(labelItemDTO), labelItemDTO.getColspan(), labelItemDTO.getAlign());
                    continue;
                }
                if (element instanceof WizardDisplayInfoDTO.ItemItemDTO) {
                    WizardDisplayInfoDTO.ItemItemDTO itemItemDTO = (WizardDisplayInfoDTO.ItemItemDTO)element;
                    String s = this.getText(itemItemDTO);
                    this.addTableCell(table, s, itemItemDTO.getColspan(), itemItemDTO.getAlign());
                    continue;
                }
                logger.warn((Object)("undefined section child type: " + element.getClass()));
            }
        } else {
            this.addTableCell(table, " ", this.section.getColdefs().size(), "");
        }
    }
}

