/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.FormRendererUtil;
import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Template;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.pdf.PdfTemplate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class TextPrinter
extends ExpertItemPrinter {
    private static Logger log = Logger.getLogger((Class)TextPrinter.class);
    private static final String DATE_FORMAT = "dd.MM.yyyy";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String DATE_TIME_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private ExpertDisplayInfoDTO.TextItemDTO item;

    protected void initalize(ExpertDisplayInfoDTO.ItemDTO item) {
        this.item = (ExpertDisplayInfoDTO.TextItemDTO)item;
    }

    public void printInternal(float xOffset, float yOffset) throws FormRendererException {
        if (this.item instanceof ExpertDisplayInfoDTO.ValueItemDTO) {
            ExpertDisplayInfoDTO.ValueItemDTO valueItem = (ExpertDisplayInfoDTO.ValueItemDTO)this.item;
            if (valueItem.getModelItem() != null && valueItem.getModelItem().getState() == 12) {
                return;
            }
            Map pos = valueItem.getValuePositions();
            if (pos != null && !pos.isEmpty()) {
                this.printValuePosition(valueItem, xOffset, yOffset);
                return;
            }
        }
        float llx = this.calcLowerLeftX(this.item, xOffset);
        float lly = this.calcLowerLeftY(this.item, yOffset);
        float urx = this.calcUpperRightX(this.item, xOffset);
        float ury = this.calcUpperRightY(this.item, yOffset);
        if (this.item instanceof ExpertDisplayInfoDTO.ValueItemDTO) {
            if (this.item.getAlignment() == 0) {
                llx += this.getDocumentContext().getValuePaddingX();
            } else if (this.item.getAlignment() == 2) {
                urx -= this.getDocumentContext().getValuePaddingX();
            }
        }
        String text = this.getText(this.item);
        if (this.item instanceof ExpertDisplayInfoDTO.LabelDTO && (text = this.doReplacements(text)).indexOf("@docpages@") > -1) {
            PdfTemplate templ = this.getDirectContent().createTemplate(urx - llx, ury - lly);
            this.getDirectContent().addTemplate(templ, llx, lly);
            this.getDocumentContext().addTemplate(new Template(templ, text, this.item.getFont(), this.item.getAlignment()));
            return;
        }
        this.printText(text, llx, lly, urx, ury, this.item.getFont(), this.item.getAlignment());
    }

    private String doReplacements(String text) {
        DocumentContext ctx = this.getDocumentContext();
        text = TextPrinter.replaceAll(text, "@formpage@", ctx.getFormPage());
        text = TextPrinter.replaceAll(text, "@formpages@", ctx.getFormPages());
        text = TextPrinter.replaceAll(text, "@extrapage@", ctx.getFormPage() - 1);
        text = TextPrinter.replaceAll(text, "@docpage@", ctx.getWriter().getPageNumber());
        text = TextPrinter.replaceAll(text, "@docpage@", ctx.getWriter().getPageNumber());
        text = TextPrinter.replaceAll(text, "@version@", FormRendererUtil.getApplicationVersion());
        text = TextPrinter.replaceDates(text, "@date@", DATE_FORMAT);
        text = TextPrinter.replaceDates(text, "@time@", TIME_FORMAT);
        text = TextPrinter.replaceDates(text, "@datetime@", DATE_TIME_FORMAT);
        return text;
    }

    private static String replaceAll(String text, String toReplace, int value) {
        if (text.indexOf(toReplace) > -1) {
            return text.replaceAll(toReplace, Integer.toString(value));
        }
        return text;
    }

    private static String replaceAll(String text, String toReplace, String value) {
        if (text.indexOf(toReplace) > -1) {
            return text.replaceAll(toReplace, value);
        }
        return text;
    }

    private static String replaceDates(String text, String toReplace, String defaultFormat) {
        int pos = text.indexOf(toReplace);
        while (pos > -1) {
            int formatEnd;
            int formatStart;
            String format = defaultFormat;
            int end = pos + toReplace.length();
            if (end < text.length() && text.charAt(end) == '#' && (formatStart = end + 1) < text.length() && (formatEnd = text.indexOf(35, formatStart)) > -1) {
                format = text.substring(formatStart, formatEnd);
                end = formatEnd + 1;
            }
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                StringBuffer sb = new StringBuffer(text);
                sb.replace(pos, end, sdf.format(new Date()));
                text = sb.toString();
            }
            catch (Exception e) {
                log.warn((Object)"date formatting failed", (Throwable)e);
            }
            pos = text.indexOf(toReplace);
        }
        return text;
    }
}

