/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer;

import ch.dvbern.tax.common.transfer.dto.BelegDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.GifImage;
import com.lowagie.text.pdf.codec.TiffImage;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Date;

public class BelegPrinter {
    String beschreibung;
    Date speicherDatum;
    private byte[] belegContent;

    public void initialize(BelegDTO beleg) {
        this.belegContent = beleg.getContent();
        this.beschreibung = beleg.getBeschreibung();
        this.speicherDatum = beleg.getSpeicherDatum();
    }

    public ByteArrayOutputStream printBelegPdf() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        com.lowagie.text.Image image = null;
        try {
            image = com.lowagie.text.Image.getInstance((byte[])this.belegContent);
        }
        catch (BadElementException e) {
            throw new ApplicationException(e);
        }
        catch (MalformedURLException e) {
            throw new ApplicationException(e);
        }
        catch (IOException e) {
            try {
                baos.write(this.belegContent);
                return baos;
            }
            catch (IOException e1) {
                throw new ApplicationException(e1);
            }
        }
        if (image != null) {
            try {
                Document document = new Document();
                PdfWriter.getInstance((Document)document, (OutputStream)baos);
                document.open();
                image.setAlignment(1);
                if (image.getWidth() > document.getPageSize().getWidth() || image.getHeight() > document.getPageSize().getHeight()) {
                    image.scaleToFit(document.getPageSize().getWidth(), document.getPageSize().getHeight());
                }
                document.add((Element)image);
                document.close();
            }
            catch (DocumentException e) {
                throw new ApplicationException(e);
            }
        }
        return baos;
    }

    private void printImagesExample() throws DocumentException, MalformedURLException, IOException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream("SimpleImages.pdf"));
        document.open();
        document = this.printImage(document);
        document.add((Element)new Paragraph("\nAWT Image"));
        document = this.printAwt(document);
        document.newPage();
        document.add((Element)new Paragraph("Multipages tiff file"));
        document = this.printTiff(document);
        document.newPage();
        document = this.printAnimatedGif(document);
        document.close();
    }

    private Document printImage(Document document) throws BadElementException, MalformedURLException, IOException, DocumentException {
        com.lowagie.text.Image image = com.lowagie.text.Image.getInstance((String)"mouse.jpg");
        document.add((Element)image);
        return document;
    }

    private Document printAwt(Document document) throws BadElementException, IOException, DocumentException {
        Image awtImg = Toolkit.getDefaultToolkit().createImage("square.jpg");
        com.lowagie.text.Image image2 = com.lowagie.text.Image.getInstance((Image)awtImg, null);
        document.add((Element)image2);
        return document;
    }

    private Document printTiff(Document document) throws IOException, DocumentException {
        RandomAccessFileOrArray ra = new RandomAccessFileOrArray("multipage.tif");
        int pages = TiffImage.getNumberOfPages((RandomAccessFileOrArray)ra);
        for (int i = 1; i <= pages; ++i) {
            document.add((Element)TiffImage.getTiffImage((RandomAccessFileOrArray)ra, (int)i));
        }
        return document;
    }

    private Document printAnimatedGif(Document document) throws DocumentException, IOException {
        document.add((Element)new Paragraph("Animated Gifs"));
        GifImage img = new GifImage("bee.gif");
        int frame_count = img.getFrameCount();
        for (int i = 1; i <= frame_count; ++i) {
            document.add((Element)img.getImage(i));
        }
        return document;
    }
}

