/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print;

import ch.dvbern.tax.common.presentation.common.print.FormRenderer;
import ch.dvbern.tax.common.presentation.common.print.html.HtmlFormRenderer;
import ch.dvbern.tax.common.presentation.common.print.pdf.PdfFormRenderer;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;

public class FormRendererFactory {
    public static final int TYPE_PDF = 0;
    public static final int TYPE_HTML = 1;

    public static FormRenderer createRenderEngine(int type, LocalizationHelper locHelper, ImageSource imgSource) {
        if (imgSource == null) {
            throw new NullPointerException("imgSource must not be null");
        }
        if (locHelper == null) {
            throw new NullPointerException("locHelper must not be null");
        }
        switch (type) {
            case 1: {
                return new HtmlFormRenderer(locHelper, imgSource);
            }
            case 0: {
                return new PdfFormRenderer(locHelper, imgSource);
            }
        }
        throw new UnsupportedOperationException("Type " + type + " unknown.");
    }
}

