/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print;

import ch.dvbern.tax.common.presentation.common.print.ProgressListener;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class FormRenderer {
    private LocalizationHelper locHelper;
    private ImageSource imgSource;
    private Collection progressListeners = new ArrayList();
    private ExpertDisplayInfoDTO wizardBackground;
    private boolean useBoldFonts = false;

    public FormRenderer(LocalizationHelper locHelper, ImageSource imgSource) {
        this.locHelper = locHelper;
        this.imgSource = imgSource;
    }

    public void setUseBoldFonts(boolean useBoldFonts) {
        this.useBoldFonts = useBoldFonts;
    }

    public boolean isUseBoldFonts() {
        return this.useBoldFonts;
    }

    public void render(ExpertDisplayInfoDTO form, OutputStream os) throws FormRendererException {
        this.render(Collections.singletonList(form), os, null);
    }

    public void render(WizardDisplayInfoDTO form, OutputStream os) throws FormRendererException {
        this.render(Collections.singletonList(form), os, null);
    }

    public abstract void render(List var1, OutputStream var2, String var3) throws FormRendererException;

    protected LocalizationHelper getLocalizationHelper() {
        return this.locHelper;
    }

    protected ImageSource getImageSource() {
        return this.imgSource;
    }

    public void addProgressListener(ProgressListener li) {
        if (li != null) {
            this.progressListeners.add(li);
        }
    }

    public void removeProgressListener(ProgressListener li) {
        if (li != null) {
            this.progressListeners.remove(li);
        }
    }

    protected void notifyProgressListeners(int form) {
        Iterator it = this.progressListeners.iterator();
        while (it.hasNext()) {
            ProgressListener listener = (ProgressListener)it.next();
            listener.formRendered(form);
        }
    }

    public void setWizardBackground(ExpertDisplayInfoDTO background) {
        this.wizardBackground = background;
    }

    protected ExpertDisplayInfoDTO getWizardBackground() {
        return this.wizardBackground;
    }
}

