/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.imports;

import ch.dvbern.tax.common.presentation.bd.TmoSession;
import ch.dvbern.tax.common.presentation.common.imports.ImportConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class ImportContext {
    private InputStream is;
    private Map dataModel;
    private int level;
    private String path;
    private ImportConfig config;
    private TmoSession session;
    private BufferedReader bufferedReader;
    private int year;

    public ImportContext(Map dataModel, InputStream is, ImportConfig config, TmoSession session) {
        this.dataModel = dataModel;
        this.is = is;
        this.config = config;
        this.path = "";
        this.level = 0;
        this.session = session;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map getDataModel() {
        return this.dataModel;
    }

    public BufferedReader getReader() {
        try {
            if (this.bufferedReader == null) {
                this.bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(this.is)));
            }
            return this.bufferedReader;
        }
        catch (IOException e) {
            throw new RuntimeException("buffered reader creation failed", e);
        }
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public ImportConfig getConfig() {
        return this.config;
    }

    public TmoSession getSession() {
        return this.session;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }
}

