/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.imports;

import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.Importer;
import ch.dvbern.tax.common.presentation.common.util.StringUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class AbstractImporter
implements Importer {
    private static final Logger log = Logger.getLogger((Class)AbstractImporter.class);
    public static final int TYPE_NOTYPE = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_INT = 2;
    public static final int TYPE_FLOAT_2 = 3;
    public static final int TYPE_FLOAT_3 = 4;
    public static final int TYPE_FLOAT_4 = 5;
    public static final int TYPE_BOOLEAN = 6;
    public static final int TYPE_DATE = 7;
    public static final int TYPE_INT_SIMPLE = 8;
    public static final int TYPE_ZEITRAUM = 9;
    public static final int TYPE_RADIO = 10;
    public static final int TYPE_COMBOBOX = 11;
    public static final int TYPE_DAY_MONTH = 12;
    public static final int TYPE_FIRST_LETTER = 13;
    public static final int TYPE_HIDDEN = 100;
    protected static final int TAG_START = 1;
    protected static final int TAG_END = 2;
    private static final String DELIMITER = "=";
    private Properties properties = null;
    private ImportContext ctx;

    public AbstractImporter(ImportContext ctx) {
        this.ctx = ctx;
        this.properties = ctx.getConfig().getImportSettings();
    }

    protected ImportContext getImportContext() {
        return this.ctx;
    }

    public final void doImport(String password) throws ImportException, IOException {
        this.importSubsystem();
    }

    public void importSubsystem() throws ImportException, IOException {
        int myLevel = this.ctx.getLevel();
        BufferedReader reader = this.ctx.getReader();
        String line = reader.readLine();
        while (line != null) {
            StringTokenizer tokenizer = new StringTokenizer(line.trim(), ";");
            if (tokenizer.hasMoreTokens()) {
                int tagname = Integer.parseInt(tokenizer.nextToken());
                if (tagname >= 100000) {
                    this.ctx.setPath(this.ctx.getPath() + ";" + tagname);
                    this.importModule(tagname);
                } else if (tagname >= 100) {
                    this.importField(tagname, line);
                }
                if (tagname == 1) {
                    this.ctx.setLevel(this.ctx.getLevel() + 1);
                }
                if (tagname == 2) {
                    this.ctx.setLevel(this.ctx.getLevel() - 1);
                    String path = this.ctx.getPath();
                    if (path.indexOf(";") > -1) {
                        this.ctx.setPath(path.substring(0, path.lastIndexOf(";")));
                    }
                    if (this.ctx.getLevel() == myLevel - 1) {
                        return;
                    }
                }
            }
            line = reader.readLine();
        }
    }

    protected void overReadNext() throws IOException {
        if (this.ctx.getPath().indexOf(";") > -1) {
            String path = this.ctx.getPath();
            this.ctx.setPath(path.substring(0, path.lastIndexOf(";")));
        }
        int myLevel = this.ctx.getLevel();
        String line = this.ctx.getReader().readLine();
        while (line != null) {
            StringTokenizer tokenizer = new StringTokenizer(line.trim(), ";");
            if (tokenizer.hasMoreTokens()) {
                int tagname = Integer.parseInt(tokenizer.nextToken());
                if (tagname == 1) {
                    this.ctx.setLevel(this.ctx.getLevel() + 1);
                }
                if (tagname == 2) {
                    this.ctx.setLevel(this.ctx.getLevel() - 1);
                    if (this.ctx.getLevel() == myLevel - 1) {
                        return;
                    }
                }
            }
            line = this.ctx.getReader().readLine();
        }
    }

    protected abstract void importField(int var1, String var2) throws ImportException, IOException;

    protected abstract void importModule(int var1) throws ImportException, IOException;

    protected ImportDTO createImportDTO(int ikey, String line) {
        if (this.ctx.getPath().length() < 2) {
            return null;
        }
        String key = this.ctx.getPath().substring(1) + ";" + ikey;
        if (this.properties.containsKey(key)) {
            StringTokenizer tokenTaxfile = new StringTokenizer(line, ";");
            if (tokenTaxfile.countTokens() < 3) {
                return null;
            }
            tokenTaxfile.nextToken();
            tokenTaxfile.nextToken();
            String value = tokenTaxfile.nextToken();
            String entry = (String)this.properties.get(key);
            StringTokenizer tokenProp = new StringTokenizer(entry, DELIMITER);
            String dmk = tokenProp.nextToken();
            String s = "";
            try {
                s = tokenProp.nextToken();
                int type = Integer.parseInt(s);
                return new ImportDTO(dmk, value, type);
            }
            catch (RuntimeException e) {
                log.warn((Object)("element not found: " + dmk + " type: " + s + " dmk=" + dmk + " value=" + value));
            }
        }
        return null;
    }

    protected ImportDTO createImportDTO(int ikey, String line, int zelleIndex) {
        ImportDTO dto = this.createImportDTO(ikey, line);
        return this.createKeyWithIndeces(dto, zelleIndex);
    }

    protected void doImport(int ikey, String line, int dokumentIndex, int zelleIndex) {
        ImportDTO dto = this.createImportDTO(ikey, line);
        if (dto != null) {
            this.save(this.createKeyWithIndeces(dto, dokumentIndex, zelleIndex));
        }
    }

    protected void doImport(int ikey, String line, int index) {
        ImportDTO dto = this.createImportDTO(ikey, line);
        if (dto != null) {
            this.save(this.createKeyWithIndeces(dto, index));
        }
    }

    protected ImportDTO createKeyWithIndeces(ImportDTO dto, int index) {
        int i;
        if (dto != null && (i = dto.dmk.indexOf("#")) >= 0) {
            dto.dmk = dto.dmk.substring(0, i) + index + dto.dmk.substring(i + 1);
        }
        return dto;
    }

    protected ImportDTO createKeyWithIndeces(ImportDTO dto, int dokumentIndex, int zelleIndex) {
        return this.createKeyWithIndeces(this.createKeyWithIndeces(dto, dokumentIndex), zelleIndex);
    }

    protected void save(ImportDTO dto) {
        this.save(dto, false);
    }

    protected void save(ImportDTO dto, boolean force) {
        SimpleDateFormat sdf_validate = new SimpleDateFormat("yyyyMMdd");
        ModelItemDTO modelItemDTO = null;
        if (dto.value == null) {
            modelItemDTO = new ModelItemDTO(null);
        } else {
            switch (dto.type) {
                case 1: {
                    modelItemDTO = new ModelItemDTO(StringUtil.unicodeToChar(dto.value));
                    break;
                }
                case 2: 
                case 8: {
                    String valueNum = dto.value.replaceAll("'", "");
                    modelItemDTO = new ModelItemDTO(new Long(valueNum));
                    break;
                }
                case 3: {
                    String valueNum = dto.value.replaceAll("'", "");
                    String s = valueNum.substring(0, valueNum.length() - 2) + "." + valueNum.substring(valueNum.length() - 2);
                    modelItemDTO = new ModelItemDTO(new Double(s));
                    break;
                }
                case 4: {
                    String valueNum = dto.value.replaceAll("'", "");
                    String s = valueNum.substring(0, valueNum.length() - 3) + "." + valueNum.substring(valueNum.length() - 3);
                    modelItemDTO = new ModelItemDTO(new Double(s));
                    break;
                }
                case 5: {
                    String valueNum = dto.value.replaceAll("'", "");
                    String s = valueNum.substring(0, valueNum.length() - 4) + "." + valueNum.substring(valueNum.length() - 4);
                    modelItemDTO = new ModelItemDTO(new Double(s));
                    break;
                }
                case 6: 
                case 10: {
                    if ("1".equals(dto.value)) {
                        modelItemDTO = new ModelItemDTO(Boolean.TRUE);
                        break;
                    }
                    modelItemDTO = new ModelItemDTO(Boolean.FALSE);
                    break;
                }
                case 7: {
                    if (dto.value.length() <= 1) {
                        return;
                    }
                    try {
                        modelItemDTO = new ModelItemDTO(sdf_validate.parse(dto.value));
                        break;
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                case 9: 
                case 11: 
                case 12: {
                    Pattern pattern = Pattern.compile("([1-2]?[0-9])([0-3][0-9])");
                    Matcher m = pattern.matcher(dto.value);
                    if (m.matches() && m.groupCount() >= 2) {
                        int imonth = Integer.parseInt(m.group(1));
                        int iday = Integer.parseInt(m.group(2));
                        int iyear = this.getImportContext().getYear();
                        Calendar cal = Calendar.getInstance();
                        cal.set(1, iyear);
                        cal.set(2, imonth - 1);
                        cal.set(5, iday);
                        cal.set(11, 0);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        modelItemDTO = new ModelItemDTO(cal.getTime());
                        break;
                    }
                    modelItemDTO = new ModelItemDTO(null);
                    break;
                }
                case 0: 
                case 13: 
                case 100: {
                    break;
                }
                default: {
                    throw new RuntimeException("type not supported: " + dto.type);
                }
            }
        }
        if (modelItemDTO == null) {
            throw new RuntimeException("type not supported: " + dto.type);
        }
        modelItemDTO = modelItemDTO.clone(3);
        modelItemDTO.setTouched();
        this.ctx.getDataModel().put(dto.dmk, modelItemDTO);
        log.debug((Object)("imported :" + dto.dmk + DELIMITER + modelItemDTO.getValue()));
    }

    public void delete(String dmk) {
        this.ctx.getDataModel().remove(dmk);
    }

    public void deleteTable(String tableDmk) {
        log.debug((Object)("delete tableentry: " + tableDmk));
        ArrayList<String> dmksToDelete = new ArrayList<String>();
        Iterator<Object> iter = this.getImportContext().getDataModel().keySet().iterator();
        while (iter.hasNext()) {
            String aDmk = (String)iter.next();
            if (!aDmk.startsWith(tableDmk)) continue;
            dmksToDelete.add(aDmk);
        }
        iter = dmksToDelete.iterator();
        while (iter.hasNext()) {
            String dmkToDelete = (String)iter.next();
            this.getImportContext().getDataModel().remove(dmkToDelete);
        }
    }

    protected void doImport(int ikey, String line) {
        ImportDTO dto = this.createImportDTO(ikey, line);
        if (dto != null) {
            this.save(dto);
        }
    }

    public static class ImportDTO
    implements Cloneable {
        public String dmk = null;
        public String value = null;
        public int type = 0;

        public ImportDTO(String dmk, String value, int type) {
            this.dmk = dmk;
            this.value = value;
            this.type = type;
        }

        public String toString() {
            return this.dmk + AbstractImporter.DELIMITER + this.value;
        }

        public Object clone() throws CloneNotSupportedException {
            return new ImportDTO(this.dmk, this.value, this.type);
        }
    }
}

