/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.widgets;

import ch.dvbern.tax.common.presentation.cd.widgets.Composite;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Display;

class LabelStyledText
extends StyledText {
    private static int NORMAL = 0;
    private static int BOLD = 1;
    private static int ITALIC = 2;
    private static int BLACK = 2;
    private static int RED = 3;
    private static int GREEN = 5;
    private static int BLUE = 9;
    private StyleRange currentStyle;
    private Stack colorState;
    private List styleRanges;
    private StringBuffer buf;
    private int styleState;

    public LabelStyledText(Composite parent, int style) {
        super((org.eclipse.swt.widgets.Composite)parent, style);
        super.setEnabled(false);
        GridData gd = new GridData(1808);
        super.setLayoutData((Object)gd);
    }

    public void setText(String text) {
        this.buf = null;
        this.styleRanges = new ArrayList();
        this.styleState = NORMAL;
        this.colorState = new Stack();
        this.colorState.push(new Integer(BLACK));
        this.currentStyle = new StyleRange();
        this.currentStyle.fontStyle = this.styleState;
        this.currentStyle.foreground = Display.getCurrent().getSystemColor(((Integer)this.colorState.peek()).intValue());
        this.currentStyle.start = 0;
        if (text == null || "".equals(text)) {
            super.setText("");
        } else {
            this.buf = new StringBuffer(text.length());
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                char ch = text.charAt(i);
                if (ch == '<') {
                    if (i + 4 <= len && text.substring(i, i + 4).toLowerCase().equals("<br>")) {
                        this.buf.append("\n");
                        i += 3;
                        continue;
                    }
                    if (i + 4 <= len && text.substring(i, i + 4).toLowerCase().equals("<li>")) {
                        this.buf.append("- ");
                        i += 3;
                        continue;
                    }
                    if (i + 3 <= len && text.substring(i, i + 3).toLowerCase().equals("<b>")) {
                        this.styleState |= BOLD;
                        this.styleChanged();
                        i += 2;
                        continue;
                    }
                    if (i + 4 <= len && text.substring(i, i + 4).toLowerCase().equals("</b>")) {
                        this.styleState &= ~BOLD;
                        this.styleChanged();
                        i += 3;
                        continue;
                    }
                    if (i + 3 <= len && text.substring(i, i + 3).toLowerCase().equals("<i>")) {
                        this.styleState |= ITALIC;
                        this.styleChanged();
                        i += 2;
                        continue;
                    }
                    if (i + 4 <= len && text.substring(i, i + 4).toLowerCase().equals("</i>")) {
                        this.styleState &= ~ITALIC;
                        this.styleChanged();
                        i += 3;
                        continue;
                    }
                    if (i + 5 <= len && text.substring(i, i + 5).toLowerCase().equals("<red>")) {
                        this.colorState.push(new Integer(RED));
                        this.colorChanged();
                        i += 4;
                        continue;
                    }
                    if (i + 6 <= len && text.substring(i, i + 6).toLowerCase().equals("</red>")) {
                        if (this.colorState.size() > 1) {
                            this.colorState.pop();
                        }
                        this.colorChanged();
                        i += 5;
                        continue;
                    }
                    if (i + 7 <= len && text.substring(i, i + 7).toLowerCase().equals("<green>")) {
                        this.colorState.push(new Integer(GREEN));
                        this.colorChanged();
                        i += 6;
                        continue;
                    }
                    if (i + 8 <= len && text.substring(i, i + 8).toLowerCase().equals("</green>")) {
                        if (this.colorState.size() > 1) {
                            this.colorState.pop();
                        }
                        this.colorChanged();
                        i += 7;
                        continue;
                    }
                    if (i + 6 <= len && text.substring(i, i + 6).toLowerCase().equals("<blue>")) {
                        this.colorState.push(new Integer(BLUE));
                        this.colorChanged();
                        i += 5;
                        continue;
                    }
                    if (i + 7 <= len && text.substring(i, i + 7).toLowerCase().equals("</blue>")) {
                        if (this.colorState.size() > 1) {
                            this.colorState.pop();
                        }
                        this.colorChanged();
                        i += 6;
                        continue;
                    }
                    while (ch != '>') {
                        ch = text.charAt(++i);
                    }
                    continue;
                }
                if (ch == '&') {
                    if (i + 6 > len || !text.substring(i, i + 6).toLowerCase().equals("&nbsp;")) continue;
                    this.buf.append(" ");
                    i += 5;
                    continue;
                }
                this.buf.append(ch);
            }
            super.setText(this.buf.toString());
        }
        StyleRange[] styleRangeArray = this.styleRanges.toArray(new StyleRange[this.styleRanges.size()]);
        this.setStyleRanges(styleRangeArray);
    }

    private void styleChanged() {
        int realPos = this.buf.length();
        this.currentStyle.length = realPos - this.currentStyle.start;
        if (this.currentStyle.length > 0) {
            this.styleRanges.add(this.currentStyle);
        }
        this.currentStyle = new StyleRange();
        this.currentStyle.start = realPos;
        this.currentStyle.fontStyle = this.styleState;
        this.currentStyle.foreground = Display.getCurrent().getSystemColor(((Integer)this.colorState.peek()).intValue());
    }

    private void colorChanged() {
        int realPos = this.buf.length();
        this.currentStyle.length = realPos - this.currentStyle.start;
        if (this.currentStyle.length > 0) {
            this.styleRanges.add(this.currentStyle);
        }
        this.currentStyle = new StyleRange();
        this.currentStyle.start = realPos;
        this.currentStyle.fontStyle = this.styleState;
        this.currentStyle.foreground = Display.getCurrent().getSystemColor(((Integer)this.colorState.peek()).intValue());
    }
}

