/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.bd.TmoSession;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.ProgressMonitorDialog;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.util.TaxFileConfigHelper;
import ch.dvbern.tax.common.presentation.common.print.FormRenderer;
import ch.dvbern.tax.common.presentation.common.print.FormRendererFactory;
import ch.dvbern.tax.common.presentation.common.print.ProgressListener;
import ch.dvbern.tax.common.presentation.common.util.FileImageSource;
import ch.dvbern.tax.common.presentation.common.util.IOUtil;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.FileDialog;

public class PrintUtil {
    private static final Logger log = Logger.getLogger((Class)PrintUtil.class);
    private static final String CLASSPATH = "lib/dvb-tax.jar";
    private static final String CLASSPATH_CANTON = "lib/canton-tax.jar";

    public static boolean printForms(List keys, boolean isCopy) {
        return PrintUtil.printForms(keys, isCopy, false);
    }

    public static boolean printForms(List keys, boolean isCopy, boolean askForSave) {
        if (keys == null || keys.isEmpty()) {
            return true;
        }
        ArrayList<WizardDisplayInfoDTO> dispInfos = new ArrayList<WizardDisplayInfoDTO>();
        TaxmeController ctrl = TaxmeController.getInstance();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Serializable form;
            FormKey key = (FormKey)it.next();
            if (key.getType() == 2) {
                form = ctrl.getTmoSession().getWizardDisplayInfoForPrinting(key.getKey());
                dispInfos.add((WizardDisplayInfoDTO)form);
                continue;
            }
            form = ctrl.getExpertDisplayInfoDTO(key.getKey(), 2);
            dispInfos.add((WizardDisplayInfoDTO)form);
        }
        ExpertDisplayInfoDTO background = ctrl.getExpertDisplayInfoDTO("wizardprintbackground", 2);
        return PrintUtil.printAndShow(dispInfos, isCopy, "tax_", background, askForSave);
    }

    public static void printFormsInBackground(TmoSession session, List formAccessKeys, List dataModelKeys, Locale locale, boolean isCopy, boolean useBoldFonts, OutputStream outputStream) throws Exception {
        ArrayList<Serializable> displayForms = new ArrayList<Serializable>();
        if (formAccessKeys != null) {
            Iterator it = formAccessKeys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                ExpertDisplayInfoDTO expertDisplayInfo = session.getExpertDisplayInfo(key, locale, 2);
                displayForms.add(expertDisplayInfo);
            }
        }
        ExpertDisplayInfoDTO wizardBackground = null;
        if (dataModelKeys != null) {
            if (dataModelKeys.size() > 0) {
                wizardBackground = session.getExpertDisplayInfo("wizardprintbackground", locale, 2);
            }
            Iterator it = dataModelKeys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                WizardDisplayInfoDTO wizardDisplayInfo = session.getWizardDisplayInfo(key);
                displayForms.add(wizardDisplayInfo);
            }
        }
        if (displayForms.size() == 0) {
            return;
        }
        FormRenderer r = FormRendererFactory.createRenderEngine(0, TaxmeController.getInstance().getLocalisationHelper(), TaxmeController.getInstance().getImageSource());
        r.setUseBoldFonts(useBoldFonts);
        if (wizardBackground != null) {
            r.setWizardBackground(wizardBackground);
        }
        r.render(displayForms, outputStream, null);
    }

    private static boolean printAndShow(List forms, boolean isCopy, String fileNamePrefix, ExpertDisplayInfoDTO wizardBackground, boolean askForSave) {
        try {
            boolean result;
            File pdf = File.createTempFile(fileNamePrefix, ".pdf", TaxmeConfig.getPdfOutputDir());
            PrintJob job = new PrintJob(forms, isCopy, pdf.getAbsolutePath(), wizardBackground);
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(TaxmeController.getInstance().getShell());
            dlg.run(true, true, job);
            boolean bl = result = !dlg.getProgressMonitor().isCanceled();
            if (result && askForSave && DialogUtil.showYesNoDialog(Messages.getString("message.print.save.pdf"))) {
                FileDialog fdlg = new FileDialog(TaxmeController.getInstance().getShell(), 8192);
                fdlg.setFileName(TaxFileConfigHelper.getFileName(TaxmeController.getInstance().getTmoSession().getDataModel()));
                fdlg.setFilterPath(TaxmeConfig.getSaveDir().getAbsolutePath());
                fdlg.setFilterExtensions(new String[]{"*.pdf"});
                boolean finished = false;
                while (!finished) {
                    File target;
                    String file = fdlg.open();
                    if (file == null) {
                        finished = true;
                        continue;
                    }
                    if (!file.toLowerCase().endsWith(".pdf")) {
                        file = file + ".pdf";
                    }
                    if ((target = new File(file)).exists()) {
                        if (!DialogUtil.showYesNoDialog(Messages.getString("message.print.save.pdf.replace"))) continue;
                        IOUtil.copy(pdf, target);
                        finished = true;
                        continue;
                    }
                    IOUtil.copy(pdf, target);
                    finished = true;
                }
            }
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            log.error((Object)"fehler beim drucken", (Throwable)e);
            if (cause instanceof PdfViewerException) {
                DialogUtil.showErrorDialog(Messages.getString("message.acroread.failed"));
            } else {
                DialogUtil.showErrorDialog(Messages.getString("message.printfailed"));
            }
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void printDirect(List forms, boolean isCopy, File out, LocalizationHelper locHelper, ImageSource imgSrc, ProgressListener progress, ExpertDisplayInfoDTO wizardBackground) throws FormRendererException {
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(out));
            String watermark = isCopy ? locHelper.translate("label.print.kopie", null) : null;
            FormRenderer r = FormRendererFactory.createRenderEngine(0, locHelper, imgSrc);
            if (progress != null) {
                r.addProgressListener(progress);
            }
            if (wizardBackground != null) {
                r.setWizardBackground(wizardBackground);
            }
            r.render(forms, fos, watermark);
        }
        catch (IOException e) {
            throw new FormRendererException("print failed", e);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new FormRendererException("print failed", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void showPdf(File file) throws PdfViewerException {
        if (TaxmeConfig.getBoolean("acroread.path.use")) {
            String path = TaxmeConfig.getString("acroread.path");
            if (!new File(path).exists()) throw new PdfViewerException("PDF Viewer not found");
            try {
                Runtime.getRuntime().exec(path + " " + file.getAbsolutePath());
                return;
            }
            catch (IOException e) {
                throw new PdfViewerException("can't launch PDF Viewer", e);
            }
        } else {
            if (Program.launch((String)file.getAbsolutePath())) return;
            if (!new File(TaxmeConfig.getString("acroread.path")).exists()) throw new PdfViewerException("can't launch PDF Viewer");
            TaxmeConfig.setValue("acroread.path.use", "true");
            PrintUtil.showPdf(file);
        }
    }

    private static void printDetached(List forms, boolean isCopy, File out, ExpertDisplayInfoDTO wizardBackground) throws FormRendererException {
        try {
            String line;
            StringBuffer cmd = new StringBuffer();
            cmd.append("java -cp ");
            cmd.append(CLASSPATH);
            cmd.append(File.pathSeparatorChar);
            cmd.append(CLASSPATH_CANTON);
            cmd.append(File.pathSeparatorChar);
            cmd.append(System.getProperty("java.class.path"));
            cmd.append(" ");
            cmd.append(PrintUtil.class.getName());
            log.debug((Object)("Starting detached printing process. Command: " + cmd));
            Process p = Runtime.getRuntime().exec(cmd.toString());
            log.debug((Object)"Process Started. Writing print job data to STDIN.");
            ObjectOutputStream os = new ObjectOutputStream(p.getOutputStream());
            os.writeObject(forms);
            os.writeBoolean(isCopy);
            os.writeObject(out);
            os.writeObject(new DetachedLocalizationHelper(TaxmeConfig.getResourceBundlePath(TaxmeController.getInstance().getLanguage()), TaxmeController.getInstance().getLocale()));
            os.writeObject(new File(TaxmeConfig.getImageDir()));
            os.writeObject(wizardBackground);
            os.close();
            log.debug((Object)"Print job written.");
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = br.readLine()) != null) {
                System.err.println(line);
                log.debug((Object)("errorstream" + line));
            }
            br.close();
            log.debug((Object)"waiting for process termination. ");
            int rc = p.waitFor();
            log.debug((Object)("process terminated. ReturnCode:" + rc));
            if (rc < 0) {
                throw new FormRendererException("detached printing failed");
            }
        }
        catch (IOException e) {
            throw new FormRendererException("can't launch detached printer", e);
        }
        catch (InterruptedException e) {
            throw new FormRendererException("interrupted", e);
        }
    }

    public static void main(String[] args) {
        try {
            log.debug((Object)"Dettached print job started.");
            ObjectInputStream is = new ObjectInputStream(System.in);
            List li = (List)is.readObject();
            boolean isCopy = is.readBoolean();
            File out = (File)is.readObject();
            LocalizationHelper locHelper = (LocalizationHelper)is.readObject();
            FileImageSource imgSrc = new FileImageSource((File)is.readObject());
            ExpertDisplayInfoDTO wizardBackground = (ExpertDisplayInfoDTO)is.readObject();
            log.debug((Object)"Print job data read.");
            PrintUtil.printDirect(li, isCopy, out, locHelper, imgSrc, null, wizardBackground);
            log.debug((Object)"Print job finished.");
            System.exit(0);
        }
        catch (Throwable e) {
            log.error((Object)"Dettached print job failed", e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static class FormKey {
        private String key;
        private int type;
        public static final int EXPERT = 1;
        public static final int WIZARD = 2;

        public FormKey(String key, int type) {
            this.key = key;
            this.type = type;
        }

        private int getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }
    }

    private static class PdfViewerException
    extends Exception {
        private static final long serialVersionUID = 2283963821878049195L;

        public PdfViewerException() {
        }

        public PdfViewerException(String message, Throwable cause) {
            super(message, cause);
        }

        public PdfViewerException(String message) {
            super(message);
        }
    }

    private static class PrintJob
    implements IRunnableWithProgress {
        private List forms;
        private boolean isCopy;
        private String fileNamePrefix;
        private ExpertDisplayInfoDTO wizardBackground;

        public PrintJob(List forms, boolean isCopy, String fileNamePrefix, ExpertDisplayInfoDTO wizardBackround) {
            this.fileNamePrefix = fileNamePrefix;
            this.forms = forms;
            this.isCopy = isCopy;
            this.wizardBackground = wizardBackround;
        }

        public void run(final IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
            try {
                int acroreadWork = 5;
                mon.beginTask(Messages.getString("message.print.running"), this.forms.size() + 1 + acroreadWork);
                mon.subTask(Messages.getString("message.print.forms"));
                File pdf = new File(this.fileNamePrefix);
                pdf.deleteOnExit();
                mon.worked(1);
                if (OsSupport.isMacOs()) {
                    PrintUtil.printDetached(this.forms, this.isCopy, pdf, this.wizardBackground);
                    mon.worked(this.forms.size());
                } else {
                    ProgressListener li = new ProgressListener(){

                        public void formRendered(int form) {
                            mon.worked(1);
                        }
                    };
                    TaxmeController ctrl = TaxmeController.getInstance();
                    PrintUtil.printDirect(this.forms, this.isCopy, pdf, ctrl.getLocalisationHelper(), ctrl.getImageSource(), li, this.wizardBackground);
                }
                if (mon.isCanceled()) {
                    return;
                }
                mon.subTask(Messages.getString("message.print.acroread"));
                PrintUtil.showPdf(pdf);
                for (int i = 0; i < acroreadWork; ++i) {
                    mon.worked(1);
                    Thread.sleep(1000L);
                }
                mon.done();
            }
            catch (FormRendererException e) {
                e.printStackTrace();
                throw new InvocationTargetException(e);
            }
            catch (PdfViewerException e) {
                e.printStackTrace();
                throw new InvocationTargetException(e);
            }
        }
    }

    private static class DetachedLocalizationHelper
    implements LocalizationHelper,
    Serializable {
        private static final long serialVersionUID = -8989422730434148018L;
        private String bundlePath;
        private Locale locale;
        private transient ResourceBundle bundle;

        public DetachedLocalizationHelper(String bundlePath, Locale locale) {
            this.bundlePath = bundlePath;
            this.locale = locale;
        }

        public Locale getCurrentLocale() throws LocalizationHelper.LocalizationHelperException {
            return this.locale;
        }

        public String translate(String key, Object[] replacementArguments) throws LocalizationHelper.LocalizationHelperException {
            try {
                if (this.bundle == null) {
                    this.bundle = new PropertyResourceBundle(new BufferedInputStream(new FileInputStream(this.bundlePath)));
                }
                String str = this.bundle.getString(key);
                if (replacementArguments != null && replacementArguments.length != 0) {
                    str = MessageFormat.format(str, replacementArguments);
                }
                return str;
            }
            catch (MissingResourceException e) {
                return '!' + key + '!';
            }
            catch (Exception e) {
                return "translation error: " + key;
            }
        }
    }
}

