/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

public class OsSupport {
    private static final int OS_OTHER = 0;
    private static final int OS_WIN = 1;
    private static final int OS_MAC = 2;
    private static final int OS_LINUX = 4;
    private static final int ARCH_IA32 = 1;
    private static final int ARCH_PPC = 2;
    private static final int ARCH_OTHER = 0;
    private static final int os;
    private static final int arch;
    private static final String version;

    private OsSupport() {
    }

    public static boolean isWindowsOs() {
        return os == 1;
    }

    public static boolean isLinuxOs() {
        return os == 4;
    }

    public static boolean isMacOs() {
        return os == 2;
    }

    public static boolean isMaxOsIntel() {
        return os == 2 && arch == 1;
    }

    public static boolean isMaxOsPpc() {
        return os == 2 && arch == 2;
    }

    public static String getVersion() {
        return version;
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        version = System.getProperty("os.version");
        if (osName.startsWith("win")) {
            os = 1;
            arch = 1;
        } else if (osName.startsWith("mac")) {
            os = 2;
            arch = osArch.equals("i386") ? 1 : 2;
        } else if (osName.startsWith("lin")) {
            os = 4;
            arch = 1;
        } else {
            os = 0;
            arch = 0;
        }
    }
}

