/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public abstract class ImmediatelyCancelable
implements IRunnableWithProgress {
    private static final Logger log = Logger.getLogger((Class)ImmediatelyCancelable.class);
    private volatile Exception error;

    public final void run(final IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
        try {
            Thread runner = new Thread(){

                public void run() {
                    try {
                        log.debug((Object)"runner started");
                        ImmediatelyCancelable.this.runInternal(mon);
                        log.debug((Object)"runner terminated");
                    }
                    catch (InterruptedException e) {
                        log.debug((Object)"interrupted", (Throwable)e);
                    }
                    catch (Exception e) {
                        log.debug((Object)"error", (Throwable)e);
                        ImmediatelyCancelable.this.error = e;
                    }
                }
            };
            runner.start();
            while (runner.isAlive() && !mon.isCanceled()) {
                Thread.sleep(100L);
            }
            if (mon.isCanceled()) {
                this.canceled();
                if (runner.isAlive()) {
                    runner.interrupt();
                }
            }
            if (this.error != null) {
                throw this.error;
            }
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    protected abstract void runInternal(IProgressMonitor var1) throws Exception;

    protected void canceled() {
    }
}

