/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.util.ColorConstants;
import ch.dvbern.tax.common.transfer.util.RgbColor;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class GuiUtil {
    private static final Logger log = Logger.getLogger((Class)GuiUtil.class);
    private static FontRegistry font_registry = null;
    private static ColorRegistry color_registry = null;
    private static ImageRegistry image_registry = null;
    public static final String COLOR_RED = ColorConstants.COLOR_RED.getName();
    public static final String COLOR_YELLOW = ColorConstants.COLOR_YELLOW.getName();
    public static final String COLOR_WHITE = ColorConstants.COLOR_WHITE.getName();
    public static final String COLOR_BLACK = ColorConstants.COLOR_BLACK.getName();
    public static final String COLOR_GREY = ColorConstants.COLOR_GREY.getName();
    public static final String COLOR_GREY_LIGHT = ColorConstants.COLOR_GREY_LIGHT.getName();
    public static final String COLOR_GREY_DARK = ColorConstants.COLOR_GREY_DARK.getName();
    public static final String COLOR_GREEN = ColorConstants.COLOR_GREEN.getName();
    public static final String COLOR_BLUE = ColorConstants.COLOR_BLUE.getName();
    public static final String COLOR_INPUT_FOCUS = ColorConstants.COLOR_INPUT_FOCUS.getName();
    public static final String COLOR_ORANGE = ColorConstants.COLOR_ORANGE.getName();
    public static final String COLOR_MISSING_VALUE = TaxmeConfig.getString("color.missing_value", COLOR_WHITE);
    public static final String COLOR_FORM_HEADER_FOREGROUND = ColorConstants.COLOR_FORM_HEADER_FOREGROUND.getName();
    public static final String COLOR_FORM_HEADER_BACKGROUND = ColorConstants.COLOR_FORM_HEADER_BACKGROUND.getName();
    public static final String COLOR_SECTION_HEADER_FOREGROUND = ColorConstants.COLOR_SECTION_HEADER_FOREGROUND.getName();
    public static final String COLOR_SECTION_HEADER_BACKGROUND = ColorConstants.COLOR_SECTION_HEADER_BACKGROUND.getName();
    public static final String COLOR_SECTION_HEADER_BACKGROUND_TRANSPARENT = ColorConstants.COLOR_SECTION_HEADER_BACKGROUND_TRANSPARENT.getName();
    public static final String COLOR_SECTION_HEADERS_FOREGROUND = ColorConstants.COLOR_SECTION_HEADERS_FOREGROUND.getName();
    public static final String COLOR_SECTION_HEADERS_FOREGROUND_TRANSPARENT = ColorConstants.COLOR_SECTION_HEADERS_FOREGROUND_TRANSPARENT.getName();
    public static final String COLOR_SECTION_HEADERS_BACKGROUND = ColorConstants.COLOR_SECTION_HEADERS_BACKGROUND.getName();
    public static final String COLOR_SECTION_LABEL_FOREGROUND = ColorConstants.COLOR_SECTION_LABEL_FOREGROUND.getName();
    public static final String COLOR_SECTION_LABEL_BACKGROUND = ColorConstants.COLOR_SECTION_LABEL_BACKGROUND.getName();
    public static final String COLOR_SECTION_INPUT_FOREGROUND = ColorConstants.COLOR_SECTION_INPUT_FOREGROUND.getName();
    public static final String COLOR_SECTION_INPUT_BACKGROUND = ColorConstants.COLOR_SECTION_INPUT_BACKGROUND.getName();
    public static final String COLOR_SECTION_INPUT_FOREGROUND_TRANSPARENT = ColorConstants.COLOR_SECTION_INPUT_FOREGROUND_TRANSPARENT.getName();
    public static final String COLOR_SECTION_INPUT_BACKGROUND_TRANSPARENT = ColorConstants.COLOR_SECTION_INPUT_BACKGROUND_TRANSPARENT.getName();
    public static final String COLOR_SECTION_INPUT_FOREGROUND_READONLY = ColorConstants.COLOR_SECTION_INPUT_FOREGROUND_READONLY.getName();
    public static final String COLOR_SECTION_INPUT_BACKGROUND_READONLY = ColorConstants.COLOR_SECTION_INPUT_BACKGROUND_READONLY.getName();
    public static final String COLOR_TABLE_HEADER_FOREGROUND = ColorConstants.COLOR_TABLE_HEADER_FOREGROUND.getName();
    public static final String COLOR_TABLE_HEADER_BACKGROUND = ColorConstants.COLOR_TABLE_HEADER_BACKGROUND.getName();
    public static final String COLOR_TABLE_HEADER_FOREGROUND_TRANSPARENT = ColorConstants.COLOR_TABLE_HEADER_FOREGROUND_TRANSPARENT.getName();
    public static final String COLOR_TABLE_HEADER_BACKGROUND_TRANSPARENT = ColorConstants.COLOR_TABLE_HEADER_BACKGROUND_TRANSPARENT.getName();
    public static final String COLOR_TABLE_HEADERS_FOREGROUND = ColorConstants.COLOR_TABLE_HEADERS_FOREGROUND.getName();
    public static final String COLOR_TABLE_HEADERS_BACKGROUND = ColorConstants.COLOR_TABLE_HEADERS_BACKGROUND.getName();
    public static final String COLOR_TABLE_CELL_FOREGROUND = ColorConstants.COLOR_TABLE_CELL_FOREGROUND.getName();
    public static final String COLOR_TABLE_CELL_BACKGROUND = ColorConstants.COLOR_TABLE_CELL_BACKGROUND.getName();
    public static final String COLOR_TABLE_CELL_FOREGROUND_TRANSPARENT = ColorConstants.COLOR_TABLE_CELL_FOREGROUND_TRANSPARENT.getName();
    public static final String COLOR_TABLE_CELL_BACKGROUND_TRANSPARENT = ColorConstants.COLOR_TABLE_CELL_BACKGROUND_TRANSPARENT.getName();
    public static final String COLOR_TABLE_CELL_FOREGROUND_READONLY = ColorConstants.COLOR_TABLE_CELL_FOREGROUND_READONLY.getName();
    public static final String COLOR_TABLE_CELL_BACKGROUND_READONLY = ColorConstants.COLOR_TABLE_CELL_BACKGROUND_READONLY.getName();
    public static final String FONT_NORMAL = "font.normal";
    public static final String FONT_DISABLED = "font.disabled";
    public static final String FONT_NAVIGATION = "font.navigation";
    public static final String FONT_HEADER_FORM = "font.header.form";
    public static final String FONT_HEADER_TABLE = "font.header.table";
    public static final String FONT_HEADER_SECTION = "font.header.section";
    public static final int FONT_SIZE_DEFAULT = 8;
    private static int font_size_basis;
    private static final int SCROLL_BORDER = 25;
    private static boolean useLargeFonts;

    public static boolean isUseLargeFonts() {
        return useLargeFonts;
    }

    public static float getZoomFactor() {
        return (float)font_size_basis / 10.0f;
    }

    public static int zoom(int x) {
        return Math.round(GuiUtil.getZoomFactor() * (float)x);
    }

    public static ColorRegistry getColorRegistry() {
        if (color_registry == null) {
            color_registry = new ColorRegistry(Display.getDefault());
            Iterator it = ColorConstants.getColors().values().iterator();
            while (it.hasNext()) {
                RgbColor col = (RgbColor)it.next();
                color_registry.put(col.getName(), new RGB(col.getRed(), col.getGreen(), col.getBlue()));
            }
        }
        return color_registry;
    }

    public static FontRegistry getFontRegistry() {
        if (font_registry == null) {
            GuiUtil.initializeFontRegistry();
        }
        return font_registry;
    }

    public static void setUseLargeFonts(boolean large) {
        GuiUtil.disposeFontRegistry();
        if (large) {
            GuiUtil.getLargeFontRegistry();
        } else {
            GuiUtil.getSmallFontRegistry();
        }
        useLargeFonts = large;
    }

    public static void initializeFontRegistry() {
        boolean large = OsSupport.isLinuxOs() ? TaxmeConfig.getBoolean("fonts.large") : OsSupport.isMacOs();
        GuiUtil.setUseLargeFonts(large);
    }

    public static void setFontSize(int fontSize) {
        font_size_basis = fontSize;
        TaxmeConfig.setValue("font.size", fontSize);
        GuiUtil.disposeFontRegistry();
    }

    private static void getSmallFontRegistry() {
        String fontname = "Arial";
        font_registry = new FontRegistry(Display.getDefault());
        font_registry.put(FONT_NORMAL, new FontData[]{new FontData(fontname, font_size_basis, 0)});
        font_registry.put(FONT_DISABLED, new FontData[]{new FontData(fontname, font_size_basis, 1)});
        font_registry.put(FONT_NAVIGATION, new FontData[]{new FontData(fontname, font_size_basis, 0)});
        font_registry.put(FONT_HEADER_FORM, new FontData[]{new FontData(fontname, font_size_basis + 4, 1)});
        font_registry.put(FONT_HEADER_TABLE, new FontData[]{new FontData(fontname, font_size_basis + 2, 1)});
        font_registry.put(FONT_HEADER_SECTION, new FontData[]{new FontData(fontname, font_size_basis + 2, 1)});
    }

    private static void getLargeFontRegistry() {
        String fontname = "Arial";
        font_registry = new FontRegistry(Display.getDefault());
        font_registry.put(FONT_NORMAL, new FontData[]{new FontData(fontname, font_size_basis + 3, 0)});
        font_registry.put(FONT_DISABLED, new FontData[]{new FontData(fontname, font_size_basis + 3, 0)});
        font_registry.put(FONT_NAVIGATION, new FontData[]{new FontData(fontname, font_size_basis + 3, 0)});
        font_registry.put(FONT_HEADER_FORM, new FontData[]{new FontData(fontname, font_size_basis + 6, 1)});
        font_registry.put(FONT_HEADER_TABLE, new FontData[]{new FontData(fontname, font_size_basis + 4, 1)});
        font_registry.put(FONT_HEADER_SECTION, new FontData[]{new FontData(fontname, font_size_basis + 4, 1)});
    }

    public static ImageRegistry getImageRegistry() {
        if (image_registry == null) {
            image_registry = new ImageRegistry(Display.getDefault());
            image_registry.put("icon.state.error", GuiUtil.createIconDesc("icon_red.gif"));
            image_registry.put("icon.state.error.transparent", GuiUtil.createIconDesc("icon_red_disabled.gif"));
            image_registry.put("icon.state.ok", GuiUtil.createIconDesc("icon_green.gif"));
            image_registry.put("icon.state.ok.transparent", GuiUtil.createIconDesc("icon_green_disabled.gif"));
            image_registry.put("icon.state.missingvalue", GuiUtil.createIconDesc("icon_white.gif"));
            image_registry.put("icon.state.missingvalue.transparent", GuiUtil.createIconDesc("icon_white_disabled.gif"));
            image_registry.put("icon.state.warning", GuiUtil.createIconDesc("icon_yellow.gif"));
            image_registry.put("icon.state.warning.transparent", GuiUtil.createIconDesc("icon_yellow_disabled.gif"));
            image_registry.put("icon.state.transparent", GuiUtil.createIconDesc("icon_crossed.gif"));
            image_registry.put("icon.state.transparent.transparent", GuiUtil.createIconDesc("icon_crossed_disabled.gif"));
            image_registry.put("icon.button.add", GuiUtil.createIconDesc("icon_add.gif"));
            image_registry.put("icon.button.edit", GuiUtil.createIconDesc("icon_edit.gif"));
            image_registry.put("icon.button.delete", GuiUtil.createIconDesc("delete.gif"));
            image_registry.put("icon.button.ok", GuiUtil.createIconDesc("ok.gif"));
            image_registry.put("icon.button.cancel", GuiUtil.createIconDesc("cancel.gif"));
            image_registry.put("icon.button.previous", GuiUtil.createIconDesc("previous.gif"));
            image_registry.put("icon.button.next", GuiUtil.createIconDesc("next.gif"));
            image_registry.put("image.about", GuiUtil.createIconDesc("about.gif"));
            image_registry.put("table.new.row", GuiUtil.createIconDesc("newRow.gif"));
            image_registry.put("icon.window.app", GuiUtil.createIconDesc("mainframe16.gif"));
            image_registry.put("icon.window.about", GuiUtil.createIconDesc("mainframe16.gif"));
            image_registry.put("icon.menu.file.dossier", GuiUtil.createIconDesc("dossier.gif"));
            image_registry.put("icon.menu.file.dossier.disabled", GuiUtil.createIconDesc("dossier-disabled.gif"));
            image_registry.put("icon.menu.edit.redo", GuiUtil.createIconDesc("redo.gif"));
            image_registry.put("icon.menu.edit.redo.disabled", GuiUtil.createIconDesc("redo-disabled.gif"));
            image_registry.put("icon.menu.edit.undo", GuiUtil.createIconDesc("undo.gif"));
            image_registry.put("icon.menu.edit.undo.disabled", GuiUtil.createIconDesc("undo-disabled.gif"));
            image_registry.put("icon.menu.file.close", GuiUtil.createIconDesc("close.gif"));
            image_registry.put("icon.menu.file.close.disabled", GuiUtil.createIconDesc("close-disabled.gif"));
            image_registry.put("icon.menu.file.exit", GuiUtil.createIconDesc("cancel.gif"));
            image_registry.put("icon.menu.file.exit.disabled", GuiUtil.createIconDesc("cancel-disabled.gif"));
            image_registry.put("icon.menu.file.new", GuiUtil.createIconDesc("new.gif"));
            image_registry.put("icon.menu.file.new.disabled", GuiUtil.createIconDesc("new-disabled.gif"));
            image_registry.put("icon.menu.file.open", GuiUtil.createIconDesc("open.gif"));
            image_registry.put("icon.menu.file.open.disabled", GuiUtil.createIconDesc("open-disabled.gif"));
            image_registry.put("icon.menu.file.import", GuiUtil.createIconDesc("import.gif"));
            image_registry.put("icon.menu.file.import.disabled", GuiUtil.createIconDesc("import-disabled.gif"));
            image_registry.put("icon.menu.file.print", GuiUtil.createIconDesc("print.gif"));
            image_registry.put("icon.menu.file.print.disabled", GuiUtil.createIconDesc("print-disabled.gif"));
            image_registry.put("icon.menu.file.save", GuiUtil.createIconDesc("save.gif"));
            image_registry.put("icon.menu.file.save.disabled", GuiUtil.createIconDesc("save-disabled.gif"));
            image_registry.put("icon.menu.file.save.as", GuiUtil.createIconDesc("save.gif"));
            image_registry.put("icon.menu.file.save.as.disabled", GuiUtil.createIconDesc("save-disabled.gif"));
            image_registry.put("icon.menu.help.mainhelp", GuiUtil.createIconDesc("mainHelp.gif"));
            image_registry.put("icon.menu.help.mainhelp.disabled", GuiUtil.createIconDesc("mainHelp-disabled.gif"));
            image_registry.put("icon.menu.help.shorthelp", GuiUtil.createIconDesc("help.gif"));
            image_registry.put("icon.menu.help.shorthelp.disabled", GuiUtil.createIconDesc("help-disabled.gif"));
            image_registry.put("icon.menu.view.mode.expert", GuiUtil.createIconDesc("expert.gif"));
            image_registry.put("icon.menu.view.mode.expert.disabled", GuiUtil.createIconDesc("expert-disabled.gif"));
            image_registry.put("icon.menu.view.mode.wizard", GuiUtil.createIconDesc("wizard.gif"));
            image_registry.put("icon.menu.view.mode.wizard.disabled", GuiUtil.createIconDesc("wizard-disabled.gif"));
            image_registry.put("icon.menu.util.model.reload", GuiUtil.createIconDesc("reload.gif"));
            image_registry.put("icon.help.back", GuiUtil.createIconDesc("helpback.gif"));
            image_registry.put("icon.help.back.disabled", GuiUtil.createIconDesc("helpback-disabled.gif"));
            image_registry.put("icon.help.next", GuiUtil.createIconDesc("helpvor.gif"));
            image_registry.put("icon.help.next.disabled", GuiUtil.createIconDesc("helpvor-disabled.gif"));
            image_registry.put("icon.help.tree.opened", GuiUtil.createIconDesc("helpopened.gif"));
            image_registry.put("icon.help.tree.closed", GuiUtil.createIconDesc("helpclosed.gif"));
            image_registry.put("icon.help.tree.leaf", GuiUtil.createIconDesc("helpleaf.gif"));
            image_registry.put("icon.help.menu.quit", GuiUtil.createIconDesc("quitHelp.gif"));
            image_registry.put("icon.help.menu.index", GuiUtil.createIconDesc("helpIndex.gif"));
            image_registry.put("icon.help.menu.bedienung", GuiUtil.createIconDesc("helpTaxme_be.gif"));
            image_registry.put("icon.help.menu.wegleitung", GuiUtil.createIconDesc("helpWegleitung.gif"));
            image_registry.put("icon.link.www", GuiUtil.createIconDesc("site.gif"));
            image_registry.put("icon.upload", GuiUtil.createIconDesc("upload.gif"));
            image_registry.put("icon.upload.disabled", GuiUtil.createIconDesc("upload-disabled.gif"));
            image_registry.put("icon.menu.file.show", GuiUtil.createIconDesc("show.gif"));
        }
        return image_registry;
    }

    private static void disposeFontRegistry() {
        if (font_registry != null) {
            Iterator iter = font_registry.getKeySet().iterator();
            while (iter.hasNext()) {
                font_registry.get((String)iter.next()).dispose();
            }
            font_registry = null;
        }
    }

    public static Image createStateImage(int state, boolean enabled) {
        switch (state) {
            case 3: {
                return enabled ? GuiUtil.getImageRegistry().get("icon.state.missingvalue") : GuiUtil.getImageRegistry().get("icon.state.missingvalue.transparent");
            }
            case 4: {
                return enabled ? GuiUtil.getImageRegistry().get("icon.state.error") : GuiUtil.getImageRegistry().get("icon.state.error.transparent");
            }
            case 2: {
                return enabled ? GuiUtil.getImageRegistry().get("icon.state.warning") : GuiUtil.getImageRegistry().get("icon.state.warning.transparent");
            }
            case 11: 
            case 12: {
                return enabled ? GuiUtil.getImageRegistry().get("icon.state.transparent") : GuiUtil.getImageRegistry().get("icon.state.transparent.transparent");
            }
        }
        return enabled ? GuiUtil.getImageRegistry().get("icon.state.ok") : GuiUtil.getImageRegistry().get("icon.state.ok.transparent");
    }

    private static ImageDescriptor createIconDesc(String name) {
        try {
            URL url = new URL("file:" + TaxmeConfig.getIconFilePath(name));
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("malformed url", e);
        }
    }

    public static void scrollToVisible(ScrolledComposite composite, Rectangle rect) {
        if (composite == null || rect == null) {
            return;
        }
        if (rect.y > 25) {
            rect.y -= 25;
        }
        rect.height += 50;
        Point orig = composite.getOrigin();
        if (rect.y < orig.y) {
            orig.y = rect.y;
            composite.setOrigin(orig);
        } else {
            Rectangle ca = composite.getClientArea();
            int bottomDiff = rect.y + rect.height - (orig.y + ca.height);
            if (bottomDiff > 0) {
                orig.y += bottomDiff;
                composite.setOrigin(orig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(ImageSource imageSoruce, String name, ImageRegistry imageRegistry) {
        Image img = imageRegistry.get(name);
        if (img == null) {
            InputStream is = null;
            try {
                is = imageSoruce.getImageAsStream(name);
                img = new Image((Device)Display.getCurrent(), is);
                imageRegistry.put(name, img);
            }
            catch (IOException e) {
                log.error((Object)e);
                Image image = null;
                return image;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return img;
    }

    static {
        int fontsize = TaxmeConfig.getInt("font.size");
        if (fontsize == 0) {
            fontsize = 8;
        }
        font_size_basis = fontsize;
    }
}

