/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;

public class FileHistory
extends Observable {
    private LinkedList history = new LinkedList();
    private int maxSize;

    public FileHistory(int maxSize) {
        this.maxSize = maxSize;
    }

    public void addEntry(File file) {
        if (file == null) {
            return;
        }
        this.history.remove(file);
        this.history.addFirst(file);
        if (this.history.size() > this.maxSize) {
            this.history.removeLast();
        }
        this.setChanged();
        this.notifyObservers(file);
    }

    public Iterator entries() {
        return Collections.unmodifiableCollection(this.history).iterator();
    }

    public File firstEntry() {
        if (this.history.size() > 0) {
            return (File)this.history.getFirst();
        }
        return null;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int currentSize() {
        return this.history.size();
    }
}

