/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class DialogUtil {
    private static final String[] YES_NO_CANCEL_BUTTONS = new String[]{"label.button.ja", "label.button.nein", "label.button.cancel"};
    private static final String[] YES_NO_BUTTONS = new String[]{"label.button.ja", "label.button.nein"};
    private static final String[] CONFIRMATION_BUTTONS = new String[]{"label.button.ok", "label.button.cancel"};
    private static final String[] OK_BUTTON = new String[]{"label.button.ok"};
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;

    private DialogUtil() {
    }

    public static void showErrorDialog(String message) {
        DialogUtil.showDialog(1, "title.error", OK_BUTTON, 0, message);
    }

    public static void showWarningDialog(String message) {
        DialogUtil.showDialog(4, "title.warning", OK_BUTTON, 0, message);
    }

    public static boolean showYesNoDialog(String message) {
        int rc = DialogUtil.showDialog(3, "title.question", YES_NO_BUTTONS, 1, message);
        return rc == 0;
    }

    public static int showYesNoCancelDialog(String message) {
        return DialogUtil.showDialog(3, "title.question", YES_NO_CANCEL_BUTTONS, 2, message);
    }

    public static void showInfoDialog(String message) {
        DialogUtil.showDialog(2, "title.info", OK_BUTTON, 0, message);
    }

    public static boolean showConfirmDialog(String message) {
        int rc = DialogUtil.showDialog(3, "title.confirm", CONFIRMATION_BUTTONS, 1, message);
        return rc == 0;
    }

    private static int showDialog(int image, String titleKey, String[] buttonKeys, int defButton, String message) {
        String[] buttons = new String[buttonKeys.length];
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i] = Messages.getString(buttonKeys[i]);
        }
        MessageDialog dlg = new MessageDialog(Display.getCurrent().getActiveShell(), Messages.getString(titleKey), null, message, image, buttons, defButton);
        return dlg.open();
    }
}

