/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ControlReuseUtil {
    private LinkedHashMap newControls = new LinkedHashMap();
    private LinkedHashMap prevControls = null;

    public void start() {
        this.prevControls = this.newControls;
        this.newControls = new LinkedHashMap();
    }

    public void end() {
        Iterator i = this.prevControls.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            this.dispose(me.getValue());
        }
        this.prevControls.clear();
    }

    private void dispose(Object obj) {
        if (obj instanceof Control) {
            Control c = (Control)obj;
            if (!c.isDisposed()) {
                if (c.getLayoutData() instanceof GridData) {
                    ((GridData)c.getLayoutData()).exclude = true;
                }
                c.dispose();
            }
        } else if (obj instanceof Widget) {
            Widget c = (Widget)obj;
            if (!c.isDisposed()) {
                c.dispose();
            }
        } else if (obj instanceof ControlEditor) {
            ControlEditor c = (ControlEditor)obj;
            c.dispose();
        }
    }

    public Control getControl(Object uid) {
        Object result = this.get(uid);
        if (result instanceof Control) {
            return (Control)result;
        }
        return null;
    }

    public Widget getWidget(Object uid) {
        Object result = this.get(uid);
        if (result instanceof Widget) {
            return (Widget)result;
        }
        return null;
    }

    public ControlEditor getControlEditor(Object uid) {
        Object result = this.get(uid);
        if (result instanceof ControlEditor) {
            return (ControlEditor)result;
        }
        return null;
    }

    public CompositeAndControlReuseUtil getCompositeAndControlReuseUtil(Object uid) {
        Object result = this.get(uid);
        if (result instanceof CompositeAndControlReuseUtil) {
            return (CompositeAndControlReuseUtil)result;
        }
        return null;
    }

    private Object get(Object uid) {
        if (!this.prevControls.containsKey(uid)) {
            return null;
        }
        Iterator i = this.prevControls.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            if (me.getKey().equals(uid)) {
                i.remove();
                this.newControls.put(me.getKey(), me.getValue());
                return me.getValue();
            }
            i.remove();
            this.dispose(me.getValue());
        }
        return null;
    }

    public void addControl(Object uid, Control control) {
        if (uid == null) {
            throw new NullPointerException("uid must not be null. control:" + control);
        }
        this.moveAboveNextControl(control);
        this.newControls.put(uid, control);
    }

    public void addWidget(Object uid, Widget control) {
        this.newControls.put(uid, control);
    }

    public void addControlEditor(Object uid, ControlEditor control) {
        this.newControls.put(uid, control);
    }

    public CompositeAndControlReuseUtil addComposite(Object uid, Composite composite, ControlReuseUtil controlReuseUtil) {
        this.moveAboveNextControl((Control)composite);
        CompositeAndControlReuseUtil cacru = new CompositeAndControlReuseUtil(composite, controlReuseUtil);
        this.newControls.put(uid, cacru);
        return cacru;
    }

    private void moveAboveNextControl(Control control) {
        if (this.prevControls.size() > 0) {
            Map.Entry me = this.prevControls.entrySet().iterator().next();
            if (me.getValue() instanceof CompositeAndControlReuseUtil) {
                CompositeAndControlReuseUtil cacru = (CompositeAndControlReuseUtil)me.getValue();
                control.moveAbove((Control)cacru.getComposite());
            } else if (me.getValue() instanceof Control) {
                control.moveAbove((Control)me.getValue());
            }
        }
    }

    public static class CompositeAndControlReuseUtil {
        private Composite composite;
        private ControlReuseUtil controlReuseUtil;

        private CompositeAndControlReuseUtil(Composite composite, ControlReuseUtil controlReuseUtil) {
            this.composite = composite;
            this.controlReuseUtil = controlReuseUtil;
        }

        public Composite getComposite() {
            return this.composite;
        }

        public ControlReuseUtil getControlReuseUtil() {
            return this.controlReuseUtil;
        }
    }
}

