/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.AuthenticationDialog;
import ch.dvbern.tax.common.presentation.cd.util.ProxyConfig;
import ch.dvbern.tax.common.transfer.util.Base64Helper;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.eclipse.swt.widgets.Display;

public class ConnectionUtil {
    private static final String PROP_HTTP_PROXY_PORT = "http.proxyPort";
    private static final String PROP_PROXY_HOST = "http.proxyHost";
    private static final String CONFIG_PROXY_PORT = "update.proxy.port";
    private static final String CONFIG_PROXY_HOST = "update.proxy.host";
    private static final String CONFIG_PROXY_AVAILABLE = "update.proxy.available";
    private static final String CONFIG_PROXY_PASSWORD = "update.proxy.password";
    private static final String CONFIG_PROXY_USER = "update.proxy.user";
    private static final String CRYPTO_ENCODING = "ISO-8859-1";
    private static final String CRYPTO_ALGORITHM = "DESede";
    private static final byte[] KEY = new byte[]{-36, -22, -116, 59, 49, -99, -29, -108, -9, -82, 103, 124, 1, -56, 124, 79, 73, 91, 121, 118, -83, -104, -89, -63};
    private static SecretKey secret;

    public static void configure() {
        ConnectionUtil.configureProxy();
        ConnectionUtil.configureAuthenticator();
    }

    private static void configureProxy() {
        Properties props = System.getProperties();
        ProxyConfig conf = ConnectionUtil.getProxyConfig();
        if (conf != null && conf.isProxyEnabled()) {
            props.put(PROP_PROXY_HOST, conf.getHost() == null ? "" : conf.getHost());
            props.put(PROP_HTTP_PROXY_PORT, Integer.toString(conf.getPort()));
        } else {
            props.remove(PROP_PROXY_HOST);
            props.remove(PROP_HTTP_PROXY_PORT);
        }
    }

    public static ProxyConfig getProxyConfig() {
        ProxyConfig conf = new ProxyConfig();
        conf.setProxyEnabled(TaxmeConfig.getBoolean(CONFIG_PROXY_AVAILABLE));
        conf.setHost(TaxmeConfig.getString(CONFIG_PROXY_HOST));
        conf.setPort(TaxmeConfig.getInt(CONFIG_PROXY_PORT));
        return conf;
    }

    public static void setProxyConfig(ProxyConfig conf) {
        TaxmeConfig.setValue(CONFIG_PROXY_AVAILABLE, Boolean.toString(conf.isProxyEnabled()));
        TaxmeConfig.setValue(CONFIG_PROXY_HOST, conf.getHost());
        TaxmeConfig.setValue(CONFIG_PROXY_PORT, Integer.toString(conf.getPort()));
        ConnectionUtil.configureProxy();
    }

    private static void configureAuthenticator() {
        Authenticator.setDefault(new MyAuthenticator());
    }

    private static void saveAuthentication(PasswordAuthentication auth) {
        TaxmeConfig.setValue(CONFIG_PROXY_USER, ConnectionUtil.encrypt(auth.getUserName()));
        TaxmeConfig.setValue(CONFIG_PROXY_PASSWORD, ConnectionUtil.encrypt(new String(auth.getPassword())));
    }

    private static PasswordAuthentication loadAuthentication() {
        String user = ConnectionUtil.decrypt(TaxmeConfig.getString(CONFIG_PROXY_USER));
        String pw = ConnectionUtil.decrypt(TaxmeConfig.getString(CONFIG_PROXY_PASSWORD));
        if (user != null) {
            return new PasswordAuthentication(user, pw == null ? new char[]{} : pw.toCharArray());
        }
        return null;
    }

    private static String encrypt(String pw) {
        if (pw == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(CRYPTO_ALGORITHM);
            cipher.init(1, secret);
            byte[] enc = cipher.doFinal(pw.getBytes(CRYPTO_ENCODING));
            return Base64Helper.encode(enc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String decrypt(String pw) {
        if (pw == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(CRYPTO_ALGORITHM);
            cipher.init(2, secret);
            byte[] data = Base64Helper.decode(pw);
            return new String(cipher.doFinal(data), CRYPTO_ENCODING);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    static /* synthetic */ PasswordAuthentication access$000() {
        return ConnectionUtil.loadAuthentication();
    }

    static {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(CRYPTO_ALGORITHM);
            secret = skf.generateSecret(new DESedeKeySpec(KEY));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class MyAuthenticator
    extends Authenticator {
        private PasswordAuthentication authResult = ConnectionUtil.access$000();
        private boolean authSaved = this.authResult != null;
        private boolean firstRun = true;

        protected PasswordAuthentication getPasswordAuthentication() {
            if (this.firstRun && this.authResult != null) {
                this.firstRun = false;
                return this.authResult;
            }
            this.firstRun = false;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    AuthenticationDialog dlg = new AuthenticationDialog(TaxmeController.getInstance().getShell());
                    if (MyAuthenticator.this.authResult != null) {
                        dlg.setAuthentication(MyAuthenticator.this.authResult);
                    }
                    dlg.setSaveSelected(MyAuthenticator.this.authSaved);
                    if (dlg.open() == 0) {
                        MyAuthenticator.this.authResult = dlg.getAuthentication();
                        if (dlg.isSaveSelected()) {
                            ConnectionUtil.saveAuthentication(MyAuthenticator.this.authResult);
                            MyAuthenticator.this.authSaved = true;
                        } else {
                            MyAuthenticator.this.authSaved = false;
                        }
                    } else {
                        MyAuthenticator.this.authResult = null;
                    }
                }
            });
            return this.authResult;
        }
    }
}

