/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools.index;

import ch.dvbern.tax.common.presentation.cd.help.event.IModelChangedListener;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpItem;
import ch.dvbern.tax.common.presentation.cd.help.model.HelpRoot;
import ch.dvbern.tax.common.presentation.cd.help.parser.HelpContentHandler;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.index.IndexGui;
import ch.dvbern.tax.common.presentation.cd.resourcetools.index.IndexModel;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IndexNewGui
extends Dialog
implements SelectionListener,
KeyListener,
FocusListener,
ISelectionChangedListener,
IModelChangedListener {
    private Browser browser;
    private Text searchTerm;
    private Text description;
    private Text indexTopic;
    private Button ok;
    private IndexGui indexGui;
    private IToolCommunicationGui callback = null;
    private IndexModel model = null;
    private List selectedHelpItems;
    private ListViewer viewer;

    public IndexNewGui(Shell parentShell, IndexGui indexGui) {
        super(parentShell);
        this.callback = indexGui.getCallback();
        this.indexGui = indexGui;
    }

    protected Control createContents(ch.dvbern.tax.common.presentation.cd.widgets.Composite composite) {
        IndexNewGui.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        ch.dvbern.tax.common.presentation.cd.widgets.Composite panel = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(parent, 0);
        this.getShell().setText("New topic");
        panel.setSize(800, 600);
        FormLayout formLayout = new FormLayout();
        panel.setLayout((Layout)formLayout);
        ch.dvbern.tax.common.presentation.cd.widgets.Composite searchComposite = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(panel, 2048);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        searchComposite.setLayoutData(data);
        formLayout = new FormLayout();
        searchComposite.setLayout((Layout)formLayout);
        Label searchTermLabel = new Label((Composite)searchComposite, 0);
        searchTermLabel.setText("Search term :");
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(20, 0);
        data.top = new FormAttachment(0, 10);
        data.bottom = new FormAttachment(100, -10);
        searchTermLabel.setLayoutData((Object)data);
        this.searchTerm = new Text((Composite)searchComposite, 2048);
        data = new FormData();
        data.left = new FormAttachment((Control)searchTermLabel, 5, -1);
        data.right = new FormAttachment(60, 0);
        data.top = new FormAttachment(0, 10);
        data.bottom = new FormAttachment(100, -10);
        this.searchTerm.setLayoutData((Object)data);
        Button searchButton = new Button((Composite)searchComposite, 8);
        searchButton.setText("Search");
        searchButton.setData((Object)new Integer(0));
        searchButton.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment((Control)this.searchTerm, 10, -1);
        data.right = new FormAttachment(80, 0);
        data.top = new FormAttachment(0, 10);
        data.bottom = new FormAttachment(100, -10);
        searchButton.setLayoutData((Object)data);
        ch.dvbern.tax.common.presentation.cd.widgets.Composite foundComposite = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(panel, 2048);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)searchComposite, 0, -1);
        data.bottom = new FormAttachment(76, 0);
        foundComposite.setLayoutData(data);
        formLayout = new FormLayout();
        foundComposite.setLayout((Layout)formLayout);
        Sash sash = new Sash((Composite)foundComposite, 512);
        sash.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(30, 0);
        sash.setLayoutData((Object)data);
        ch.dvbern.tax.common.presentation.cd.widgets.Composite listFoundComposite = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(foundComposite, 2048);
        data = new FormData();
        data.top = new FormAttachment(8, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)sash, 0);
        listFoundComposite.setLayoutData(data);
        listFoundComposite.setLayout((Layout)new FillLayout());
        this.createListViewer(listFoundComposite, this.callback);
        ch.dvbern.tax.common.presentation.cd.widgets.Composite browserFoundComposite = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(foundComposite, 2048);
        data = new FormData();
        data.top = new FormAttachment(8, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment((Control)sash, 0);
        data.right = new FormAttachment(100, 0);
        browserFoundComposite.setLayoutData(data);
        browserFoundComposite.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)browserFoundComposite, 0);
        this.displayHTML();
        ch.dvbern.tax.common.presentation.cd.widgets.Composite descriptionComposite = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(panel, 2048);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)foundComposite, 0, -1);
        data.bottom = new FormAttachment(88, 0);
        descriptionComposite.setLayoutData(data);
        formLayout = new FormLayout();
        descriptionComposite.setLayout((Layout)formLayout);
        Label descriptionLabel = new Label((Composite)descriptionComposite, 0);
        descriptionLabel.setText("Description :");
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, 0);
        data.top = new FormAttachment(0, 10);
        descriptionLabel.setLayoutData((Object)data);
        this.description = new Text((Composite)descriptionComposite, 2048);
        data = new FormData();
        data.left = new FormAttachment((Control)descriptionLabel, 0, -1);
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(0, 10);
        this.description.setLayoutData((Object)data);
        Button changeDescription = new Button((Composite)descriptionComposite, 8);
        changeDescription.setText("Change description");
        changeDescription.setData((Object)new Integer(1));
        changeDescription.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(25, -10);
        data.top = new FormAttachment((Control)this.description, 10, -1);
        changeDescription.setLayoutData((Object)data);
        Button removeFromList = new Button((Composite)descriptionComposite, 8);
        removeFromList.setText("Remove from list");
        removeFromList.setData((Object)new Integer(2));
        removeFromList.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(25, 0);
        data.right = new FormAttachment(50, -10);
        data.top = new FormAttachment((Control)this.description, 10, -1);
        removeFromList.setLayoutData((Object)data);
        ch.dvbern.tax.common.presentation.cd.widgets.Composite indexTopicComposite = new ch.dvbern.tax.common.presentation.cd.widgets.Composite(panel, 2048);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)descriptionComposite, 0, -1);
        data.bottom = new FormAttachment(100, 0);
        indexTopicComposite.setLayoutData(data);
        formLayout = new FormLayout();
        indexTopicComposite.setLayout((Layout)formLayout);
        Label indexTopicLabel = new Label((Composite)indexTopicComposite, 0);
        indexTopicLabel.setText("Index topic :");
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(15, 0);
        data.top = new FormAttachment(0, 10);
        indexTopicLabel.setLayoutData((Object)data);
        this.indexTopic = new Text((Composite)indexTopicComposite, 2048);
        this.indexTopic.addKeyListener((KeyListener)this);
        data = new FormData();
        data.left = new FormAttachment((Control)indexTopicLabel, 0, -1);
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(0, 10);
        this.indexTopic.setLayoutData((Object)data);
        this.ok = new Button((Composite)indexTopicComposite, 8);
        this.ok.setText("OK");
        this.ok.setEnabled(false);
        this.ok.setData((Object)new Integer(4));
        this.ok.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(20, 0);
        data.right = new FormAttachment(40, 0);
        data.top = new FormAttachment((Control)this.indexTopic, 10, -1);
        this.ok.setLayoutData((Object)data);
        Button cancel = new Button((Composite)indexTopicComposite, 8);
        cancel.setText("Cancel");
        cancel.setData((Object)new Integer(3));
        cancel.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(60, 0);
        data.right = new FormAttachment(80, 0);
        data.top = new FormAttachment((Control)this.indexTopic, 10, -1);
        cancel.setLayoutData((Object)data);
        return panel;
    }

    protected Control createButtonBar(ch.dvbern.tax.common.presentation.cd.widgets.Composite parent) {
        return null;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Sash) {
            Sash sash = (Sash)e.getSource();
            ((FormData)sash.getLayoutData()).left = new FormAttachment(0, e.x);
            sash.getParent().layout();
        } else if (e.getSource() instanceof Button) {
            Button selectedButton = (Button)e.getSource();
            int data = (Integer)selectedButton.getData();
            switch (data) {
                case 0: {
                    this.search();
                    break;
                }
                case 1: {
                    this.changeDescription();
                    break;
                }
                case 2: {
                    this.removeFromList();
                    break;
                }
                case 3: {
                    this.cancel();
                    break;
                }
                case 4: {
                    this.ok();
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void refreshView(HelpItem topic, String property) {
    }

    public void refreshView(HelpRoot topic, String property) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ListViewer viewer;
        if (event.getSource() instanceof ListViewer && (viewer = (ListViewer)event.getSource()).getSelection() instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)viewer.getSelection();
            this.selectedHelpItems = selection.toList();
            this.displayHTML((HelpItem)selection.getFirstElement());
        }
    }

    private void createListViewer(ch.dvbern.tax.common.presentation.cd.widgets.Composite parent, IToolCommunicationGui pCallBack) {
        this.viewer = new ListViewer((Composite)parent);
        this.model = new IndexModel(this.callback, this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.model);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.model);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void displayHTML(HelpItem item) {
        String mainHelpDir = this.callback.toolGetCurrentMainHelpDirectory() + this.callback.toolGetCurrentLanguage();
        try {
            URL url = new URL("file:" + mainHelpDir + "/" + item.getTopic());
            File file = new File(url.getFile());
            if (file.exists() && !file.isDirectory()) {
                this.browser.setUrl(url.toExternalForm());
            } else {
                this.browser.setText("");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void displayHTML() {
    }

    private void search() {
        try {
            this.model.search(this.searchTerm.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeDescription() {
        if (this.selectedHelpItems.size() == 1) {
            String newDesc = this.description.getText();
            ((HelpItem)this.selectedHelpItems.get(0)).setName(newDesc);
            this.viewer.refresh();
        }
    }

    private void removeFromList() {
        boolean hasToDeleteTopic;
        if (this.selectedHelpItems.size() > 0 && (hasToDeleteTopic = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Select an option", (String)"Would you really like to delete the selected topic ?"))) {
            ArrayList input = (ArrayList)this.viewer.getInput();
            for (int i = 0; i < this.selectedHelpItems.size(); ++i) {
                input.remove(this.selectedHelpItems.get(i));
            }
            this.viewer.setInput((Object)input);
        }
    }

    private void ok() {
        HelpItem newRootHelpItem = new HelpItem();
        newRootHelpItem.setParent(this.callback.toolGetMainHelpIndexModel());
        newRootHelpItem.setName(this.indexTopic.getText());
        for (int i = 0; i < this.selectedHelpItems.size(); ++i) {
            ((HelpItem)this.selectedHelpItems.get(i)).setParent(newRootHelpItem);
        }
        ArrayList input = (ArrayList)this.viewer.getInput();
        for (int i = 0; i < input.size(); ++i) {
            newRootHelpItem.addItem((HelpItem)input.get(i));
        }
        ((HelpRoot)HelpContentHandler.getHelpModel().getRoots().get(2)).addItem(newRootHelpItem);
        this.indexGui.refreshView((HelpRoot)HelpContentHandler.getHelpModel().getRoots().get(2), "");
        this.close();
    }

    private void cancel() {
        this.close();
    }

    public boolean close() {
        this.model = null;
        return super.close();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (this.indexTopic.getText().equals("")) {
            this.ok.setEnabled(false);
        } else {
            this.ok.setEnabled(true);
        }
    }
}

