/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools.html;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.resourcetools.IToolCommunicationGui;
import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HTMLEditorPathGui
extends Dialog
implements SelectionListener {
    private Shell shell;
    private Text path;
    private String htmlEditorPath;
    private IToolCommunicationGui callback = null;

    public HTMLEditorPathGui(Shell parentShell, IToolCommunicationGui callback) {
        super(parentShell);
        this.initPath();
        this.shell = parentShell;
        this.callback = callback;
    }

    public HTMLEditorPathGui(IToolCommunicationGui callback) {
        super(callback.getCallBackShell());
        this.initPath();
        this.shell = callback.getCallBackShell();
        this.callback = callback;
    }

    private void initPath() {
        this.htmlEditorPath = TaxmeConfig.getString("ToolHtmlEditorName");
        if (this.htmlEditorPath == null) {
            TaxmeConfig.setValue("ToolHtmlEditorName", "");
        }
        System.out.println("PATH = " + this.path);
    }

    public IToolCommunicationGui getCallback() {
        return this.callback;
    }

    protected Control createDialogArea(Composite parent) {
        ((Shell)parent).setText("Taxme Tools");
        parent.setSize(600, 150);
        Label choosePath = new Label(parent, 0);
        choosePath.setText("Please choose an extern HTML editor");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 5);
        choosePath.setLayoutData((Object)data);
        this.path = new Text(parent, 2048);
        this.path.setText(TaxmeConfig.getString("ToolHtmlEditorName"));
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(75, 0);
        data.top = new FormAttachment((Control)choosePath, 10, -1);
        this.path.setLayoutData((Object)data);
        Button browse = new Button(parent, 8);
        browse.setText("Browse");
        browse.addSelectionListener((SelectionListener)this);
        browse.setData((Object)new Integer(0));
        data = new FormData();
        data.left = new FormAttachment((Control)this.path, 5, -1);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)choosePath, 10, -1);
        browse.setLayoutData((Object)data);
        Button ok = new Button(parent, 8);
        ok.setText("Ok");
        ok.setData((Object)new Integer(1));
        ok.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(25, 0);
        data.right = new FormAttachment(45, 0);
        data.top = new FormAttachment((Control)this.path, 10, -1);
        ok.setLayoutData((Object)data);
        Button cancel = new Button(parent, 8);
        cancel.setText("Cancel");
        cancel.setData((Object)new Integer(2));
        cancel.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(55, 0);
        data.right = new FormAttachment(75, 0);
        data.top = new FormAttachment((Control)this.path, 10, -1);
        cancel.setLayoutData((Object)data);
        parent.layout();
        return parent;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button selectedButton = (Button)e.getSource();
            int data = (Integer)selectedButton.getData();
            switch (data) {
                case 0: {
                    this.browseClicked();
                    break;
                }
                case 1: {
                    this.okClicked();
                    break;
                }
                case 2: {
                    this.cancelClicked();
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected Layout getLayout() {
        return new FormLayout();
    }

    protected Control createContents(Composite composite) {
        this.dialogArea = this.createDialogArea(composite);
        return composite;
    }

    public String getHtmlEditorPath() {
        return this.path.getText();
    }

    private void browseClicked() {
        FileDialog fileBrowser = new FileDialog(this.getShell(), 4096);
        fileBrowser.setFilterPath("C:/");
        String fileToOpen = fileBrowser.open();
        if (fileToOpen != null && !fileToOpen.equals("")) {
            this.path.setText(fileBrowser.getFilterPath() + System.getProperty("file.separator") + fileBrowser.getFileName());
        }
    }

    private void okClicked() {
        File editor = new File(this.getHtmlEditorPath());
        if (this.getHtmlEditorPath().trim().equals("") || !editor.exists()) {
            MessageDialog.openInformation((Shell)this.shell, (String)"Error", (String)"No valid HTML editor has been defined");
            return;
        }
        this.getCallback().toolSaveHtmlEditorName(this.getHtmlEditorPath());
        this.close();
    }

    private void cancelClicked() {
        this.close();
    }
}

