/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.resourcetools;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.dialog.TranslationDialog;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TranslationManager {
    private static TranslationManager instance = null;
    private Map resources = null;
    private Set setTranslations = new HashSet();
    private Set setTranslationsPrint = null;
    private Map registeredControls = new HashMap();
    private TranslationMouseListener mouseListener;
    private TranslationDisposeListener disposeListener;

    private TranslationManager() {
        this.resources = new HashMap();
        try {
            int language_count = TaxmeConfig.getInt("language.count");
            for (int i = 0; i < language_count; ++i) {
                String language = TaxmeConfig.getString("language." + i);
                Properties properties = new Properties();
                properties.load(new BufferedInputStream(new FileInputStream(TaxmeConfig.getResourceBundlePath(language))));
                this.resources.put(language, properties);
            }
            this.mouseListener = new TranslationMouseListener();
            this.disposeListener = new TranslationDisposeListener();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized TranslationManager getInstance() {
        if (instance == null) {
            instance = new TranslationManager();
        }
        return instance;
    }

    public DisposeListener getDisposeListener() {
        return this.disposeListener;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public Map getRegisteredControls() {
        return this.registeredControls;
    }

    public Map getResourceMap() {
        return this.resources;
    }

    public Set getTranslationMap() {
        return this.setTranslations;
    }

    public Set getPrintMap() {
        if (this.setTranslationsPrint == null) {
            this.fillPrintTranslationMap();
        }
        return this.setTranslationsPrint;
    }

    public void translate(String key) {
        if (key != null) {
            TranslationDialog dialog = new TranslationDialog(TaxmeController.getInstance().getShell(), key);
            dialog.open();
        }
    }

    public void save() {
        Iterator iter = this.resources.keySet().iterator();
        while (iter.hasNext()) {
            String locale = (String)iter.next();
            Properties p = (Properties)this.resources.get(locale);
            try {
                p.store(new BufferedOutputStream(new FileOutputStream(TaxmeConfig.getResourceBundlePath(locale))), null);
                Messages.reload();
                TaxmeController.getInstance().update();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void registerControl(Control control, String key) {
        if (!this.getRegisteredControls().containsKey(control)) {
            control.addMouseListener(this.getMouseListener());
            control.addDisposeListener(this.getDisposeListener());
            this.getRegisteredControls().put(control, key);
        }
    }

    private void fillPrintTranslationMap() {
        this.setTranslationsPrint = new HashSet();
        if (!TaxmeConfig.isExpertModeEnabled()) {
            return;
        }
        List navDTOs = TaxmeController.getInstance().getTmoSession().getExpertNavigationItems();
        Iterator iter = navDTOs.iterator();
        while (iter.hasNext()) {
            ExpertDisplayInfoDTO.NavigationDTO navDTO = (ExpertDisplayInfoDTO.NavigationDTO)iter.next();
            if (navDTO.isExtraForm()) continue;
            if (navDTO.getSubItems() != null) {
                List list = navDTO.getSubItems();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExpertDisplayInfoDTO.NavigationDTO childNavigationDTO = (ExpertDisplayInfoDTO.NavigationDTO)iterator.next();
                    ExpertDisplayInfoDTO childDisplayDTO = TaxmeController.getInstance().getExpertDisplayInfoDTO(childNavigationDTO.getAccessKey(), 1);
                    this.fillPrintTranslationMap(childDisplayDTO);
                }
                continue;
            }
            ExpertDisplayInfoDTO displayDTO = TaxmeController.getInstance().getExpertDisplayInfoDTO(navDTO.getAccessKey(), 1);
            this.fillPrintTranslationMap(displayDTO);
        }
    }

    private void fillPrintTranslationMap(ExpertDisplayInfoDTO displayDTO) {
        if (displayDTO.getName() != null) {
            this.setTranslationsPrint.add(displayDTO.getName());
        }
        List items = displayDTO.getItems();
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            ExpertDisplayInfoDTO.ItemDTO itemDTO = (ExpertDisplayInfoDTO.ItemDTO)iterator.next();
            if (itemDTO instanceof ExpertDisplayInfoDTO.LabelDTO) {
                if (((ExpertDisplayInfoDTO.LabelDTO)itemDTO).getKey() == null) continue;
                this.setTranslationsPrint.add(((ExpertDisplayInfoDTO.LabelDTO)itemDTO).getKey());
                continue;
            }
            if (!(itemDTO instanceof ExpertDisplayInfoDTO.TableDTO)) continue;
            ExpertDisplayInfoDTO.TableDTO tableDTO = (ExpertDisplayInfoDTO.TableDTO)itemDTO;
            if (tableDTO.getTitle() != null) {
                this.setTranslationsPrint.add(tableDTO.getTitle());
            }
            List columnDTOs = tableDTO.getAllColumns();
            Iterator iterator2 = columnDTOs.iterator();
            while (iterator2.hasNext()) {
                ExpertDisplayInfoDTO.TableDTO.ColumnDTO columnDTO = (ExpertDisplayInfoDTO.TableDTO.ColumnDTO)iterator2.next();
                if (columnDTO.getTitle() == null) continue;
                this.setTranslationsPrint.add(columnDTO.getTitle());
            }
        }
    }

    class TranslationDisposeListener
    implements DisposeListener {
        TranslationDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent disposeEvent) {
            ((Control)disposeEvent.getSource()).removeMouseListener((MouseListener)TranslationManager.this.mouseListener);
        }
    }

    class TranslationMouseListener
    implements MouseListener {
        TranslationMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent arg0) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 3) {
                if (mouseEvent.getSource() instanceof Tree) {
                    Tree tree = (Tree)mouseEvent.getSource();
                    TreeItem item = tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    if (item != null) {
                        WizardDisplayInfoDTO.NavigationsItemDTO navDTO = (WizardDisplayInfoDTO.NavigationsItemDTO)item.getData();
                        TranslationManager.this.translate(navDTO.getTitle());
                    }
                } else if (mouseEvent.getSource() instanceof org.eclipse.swt.widgets.List) {
                    org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)mouseEvent.getSource();
                    int y = mouseEvent.y / list.getItemHeight();
                    if (list.getItemCount() >= y && list.getData() instanceof ArrayList) {
                        ArrayList translations = (ArrayList)list.getData();
                        TranslationManager.this.translate((String)translations.get(y));
                    }
                } else if (mouseEvent.getSource() instanceof Table) {
                    Table table = (Table)mouseEvent.getSource();
                    TableItem item = table.getItem(new Point(mouseEvent.x, mouseEvent.y));
                    Object itemData = item.getData();
                    if (itemData != null && itemData instanceof MessageItemDTO) {
                        MessageItemDTO msgItem = (MessageItemDTO)itemData;
                        TranslationManager.this.translate(msgItem.getKey());
                    }
                } else {
                    Control control = (Control)mouseEvent.getSource();
                    String key = (String)TranslationManager.this.registeredControls.get(control);
                    TranslationManager.this.translate(key);
                }
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }
    }
}

