/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.help.util.ShortHelpMapping;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.parts.IValuePart;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.cd.util.ScrollingFocusListener;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.presentation.cd.widgets.Text;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TextPart
extends ch.dvbern.tax.common.presentation.cd.widgets.Composite
implements IValuePart {
    private static final Control[] EMPTY_TAB_LIST = new Control[0];
    private static final Logger log = Logger.getLogger((Class)TextPart.class);
    private static final ScrollingFocusListener focusListener = new ScrollingFocusListener();
    private static final Color WHITE = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE);
    private static final Color YELLOW = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_YELLOW);
    private static final Color ORANGE = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_ORANGE);
    private static final Color RED = GuiUtil.getColorRegistry().get(GuiUtil.COLOR_RED);
    private Point originalSize;
    private Point originalLocation;
    private Text text;
    private BorderedLabel label;
    private final TextListener textListener = new TextListener();
    private Pattern pattern;
    private String regex;
    private IValueItem item;
    private String oldValue;
    private List focusListeners = new ArrayList();
    private List mouseListeners = new ArrayList();

    public TextPart(Composite parent) {
        super(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.setLayoutData(gd);
    }

    public void addFocusListener(FocusListener arg0) {
        this.focusListeners.add(arg0);
        if (this.text != null) {
            this.text.addFocusListener(arg0);
        }
    }

    public void removeFocusListener(FocusListener arg0) {
        this.focusListeners.remove(arg0);
        if (this.text != null) {
            this.text.removeFocusListener(arg0);
        }
    }

    public void addMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.add(arg0);
        if (this.text != null) {
            this.text.addMouseListener(arg0);
        }
    }

    public void removeMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.remove(arg0);
        if (this.text != null) {
            this.text.removeMouseListener(arg0);
        }
    }

    private void initText() {
        boolean border = this.item.hasBorder();
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        if (this.text != null) {
            boolean hasBorder;
            boolean bl = hasBorder = (this.text.getStyle() & 0x800) != 0;
            if (border != hasBorder) {
                this.text.dispose();
                this.text = null;
            }
        }
        if (this.text == null) {
            FocusListener li;
            int align = 16384;
            if ("right".equals(this.item.getAlign())) {
                align = 131072;
            } else if ("center".equals(this.item.getAlign())) {
                align = 0x1000000;
            }
            this.text = new Text(this, 4 | (border ? 2048 : 0) | align);
            this.text.addFocusListener(focusListener);
            this.text.setLayoutData(new GridData(1808));
            this.text.addModifyListener(this.textListener);
            this.text.addFocusListener(this.textListener);
            Iterator it = this.focusListeners.iterator();
            while (it.hasNext()) {
                li = (FocusListener)it.next();
                this.text.addFocusListener(li);
            }
            it = this.mouseListeners.iterator();
            while (it.hasNext()) {
                li = (MouseListener)it.next();
                this.text.addMouseListener((MouseListener)li);
            }
            if (OsSupport.isMacOs()) {
                this.text.addListener(27, this.textListener);
            }
        }
        this.textListener.setEnabled(false);
        this.oldValue = this.item.getRenderedValue();
        this.text.setText(this.oldValue);
        if (OsSupport.isMaxOsPpc() && OsSupport.getVersion().startsWith("10.3")) {
            this.text.setBackground(WHITE);
            if (YELLOW.equals((Object)this.item.getBackgroundColor())) {
                this.text.setForeground(ORANGE);
            } else if (RED.equals((Object)this.item.getBackgroundColor())) {
                this.text.setForeground(RED);
            } else {
                this.text.setForeground(this.item.getForegroundColor());
            }
        } else {
            this.text.setBackground(this.item.getBackgroundColor());
            this.text.setForeground(this.item.getForegroundColor());
        }
        this.text.setFont(this.item.getFont());
        if (this.item.getStyle() != 0) {
            if (this.item.getForegroundColor() == null) {
                this.text.setEnabled(false);
            }
            if (!this.doSetFocusOnReadonlyFields()) {
                this.text.setEditable(false);
            } else {
                this.text.setEditable(true);
            }
            if (this.getTabList().length > 0 && !this.doSetFocusOnReadonlyFields()) {
                this.setTabList(EMPTY_TAB_LIST);
            }
        } else {
            this.text.setEnabled(true);
            this.text.setEditable(true);
            String newRegex = this.item.getRegularExpression();
            if (newRegex == null) {
                this.pattern = null;
            } else if (!newRegex.equals(this.regex)) {
                this.pattern = Pattern.compile(newRegex);
            }
            this.regex = newRegex;
            this.textListener.setEnabled(true);
            if (this.getTabList().length == 0) {
                this.setTabList(new Control[]{this.text});
            }
        }
    }

    private void initLabel() {
        if (this.text != null) {
            this.text.dispose();
            this.text = null;
        }
        if (this.label == null) {
            int align = 16384;
            if ("right".equals(this.item.getAlign())) {
                align = 131072;
            } else if ("center".equals(this.item.getAlign())) {
                align = 0x1000000;
            }
            this.label = new BorderedLabel(this, 0 | align);
            this.label.setLayoutData(new GridData(1808));
        }
        this.label.setFont(this.item.getFont());
        this.label.setText(this.item.getRenderedValue());
        this.label.setBackground(this.item.getBackgroundColor());
        this.label.setForeground(this.item.getForegroundColor());
    }

    public void init(IValueItem item) {
        this.item = item;
        this.originalSize = null;
        GridData gd = (GridData)this.getLayoutData();
        gd.horizontalSpan = item.getColspan();
        gd.verticalSpan = item.getRowspan();
        this.setLayoutData(gd);
        if (item.getStyle() == 3) {
            this.initLabel();
        } else {
            this.initText();
        }
        if (item.getBackgroundColor() != null) {
            this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY_LIGHT));
        } else {
            this.setBackground(null);
        }
        this.layout();
    }

    private boolean doSetFocusOnReadonlyFields() {
        boolean setFocus = TaxmeConfig.getBoolean("set.focus.on.readonly.fields");
        if (setFocus) {
            boolean toolsEnabled = Boolean.valueOf(TaxmeConfig.getString("ToolsEnabled"));
            return ShortHelpMapping.getString(this.item.getShortHelpKey()) != null || toolsEnabled;
        }
        return false;
    }

    public boolean setFocus() {
        if (this.text != null && (this.text.getEditable() || this.doSetFocusOnReadonlyFields())) {
            return this.text.setFocus();
        }
        return false;
    }

    private void adjustToTextWidth() {
        if (this.text == null) {
            return;
        }
        int textWidth = this.getTextWidth();
        int origWidth = this.originalSize == null ? this.getSize().x : this.originalSize.x;
        int contentWidth = origWidth - 2 * this.text.getBorderWidth() - 10;
        if (contentWidth < textWidth) {
            if (this.originalSize == null) {
                this.originalSize = this.getSize();
            }
            if (this.originalLocation == null) {
                this.originalLocation = this.getLocation();
            }
            int width = this.text.getSize().x - 2 * this.text.getBorderWidth() - 10;
            int diff = textWidth - width;
            this.setNewSize(diff);
            this.setNewLocation(diff);
            Control[] tabList = this.getParent().getTabList();
            this.moveAbove(null);
            this.getParent().setTabList(tabList);
        } else {
            this.resetWithAndLocation();
        }
    }

    private void setNewSize(int diff) {
        int size = this.getSize().x;
        size += diff;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Feld um " + diff + " gewachsen auf " + size));
        }
        int c = this.getLocation().x;
        int a = this.getParent().getSize().x;
        int d = this.getParent().getLocation().x + this.getParent().getSize().x - (this.getLocation().x + this.getSize().x);
        if ("right".equals(this.item.getAlign())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"rechts ausgerichtet -> nach links wachsen");
            }
            if (size > a - d) {
                size = a - d;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Ueber Seitenrand hinaus, size begrenzt auf " + size));
                }
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"links ausgerichtet -> nach rechts wachsen");
            }
            if (size > a - c) {
                size = a - c;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Ueber Seitenrand hinaus, size begrenzt auf " + size));
                }
            }
        }
        Point pSize = this.getSize();
        pSize.x = size;
        this.setSize(pSize);
    }

    private void setNewLocation(int diff) {
        int location = this.getLocation().x;
        if ("right".equals(this.item.getAlign())) {
            location -= diff;
            if (log.isDebugEnabled()) {
                log.debug((Object)("location nach links verschoben auf " + location));
            }
        }
        if (location < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"location kann nicht mehr verschoben werden -> linker rand erreicht!");
            }
            location = 0;
        }
        Point pLocation = this.getLocation();
        pLocation.x = location;
        this.setLocation(pLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTextWidth() {
        String s = this.text.getText();
        GC gc = new GC((Drawable)this.text);
        try {
            gc.setFont(this.text.getFont());
            int n = gc.stringExtent((String)s).x;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    private void resetWithAndLocation() {
        if (this.text == null) {
            return;
        }
        if (this.originalSize != null && !this.getSize().equals((Object)this.originalSize)) {
            this.setSize(this.originalSize);
        }
        if (this.originalLocation != null && !this.getLocation().equals((Object)this.originalLocation)) {
            this.setLocation(this.originalLocation);
        }
        this.originalSize = null;
        this.originalLocation = null;
    }

    private class TextListener
    implements ModifyListener,
    FocusListener,
    Listener {
        private boolean enabled = false;

        private TextListener() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void modifyText(ModifyEvent event) {
            if (!this.enabled) {
                return;
            }
            this.supportEntry(event);
            if (TextPart.this.item.isDynamicWidth()) {
                TextPart.this.adjustToTextWidth();
            }
        }

        public void focusGained(FocusEvent ev) {
            if (TextPart.this.item.isDynamicWidth()) {
                TextPart.this.adjustToTextWidth();
            }
            TextPart.this.text.selectAll();
        }

        public void focusLost(FocusEvent ev) {
            this.handleEvent(null);
        }

        public void handleEvent(Event ev) {
            if (!this.enabled) {
                return;
            }
            String newValue = TextPart.this.text.getText();
            if (!newValue.equals(TextPart.this.oldValue) || TextPart.this.item.isValidateIfLeftEmpty() && TextPart.this.item.getState() == 3) {
                this.enabled = false;
                TextPart.this.item.update(newValue);
            }
            if (TextPart.this.item.isDynamicWidth()) {
                TextPart.this.resetWithAndLocation();
            }
            if (TextPart.this.text != null && !TextPart.this.text.isDisposed()) {
                String s = TextPart.this.text.getText();
                if (TextPart.this.item.isDynamicWidth() && s.length() > 0 && (TextPart.this.text.getStyle() & 0x20000) != 0) {
                    TextPart.this.text.setSelection(s.length() - 1);
                    TextPart.this.text.showSelection();
                } else {
                    TextPart.this.text.setSelection(0);
                }
            }
        }

        private void supportEntry(ModifyEvent event) {
            Text textPart = (Text)((Object)event.getSource());
            int position = textPart.getCaretPosition();
            if (position <= 0) {
                return;
            }
            String text = textPart.getText();
            boolean matches = true;
            if (TextPart.this.pattern != null) {
                Matcher m = TextPart.this.pattern.matcher(text);
                matches = m.matches();
            }
            if (!matches || TextPart.this.item.calcLength(text) > TextPart.this.item.getMaxLength()) {
                String oldText = textPart.getText().substring(0, position - 1) + textPart.getText().substring(position);
                textPart.setText(oldText);
                textPart.setSelection(position - 1);
            }
        }
    }
}

