/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.parts.TableLabelProvider;
import java.text.Collator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerSorter
extends ViewerSorter {
    private TableViewer tableViewer;
    private int sortColumn = -1;
    private boolean asc = false;
    private Collator collator = Collator.getInstance(TaxmeController.getInstance().getLocale());

    public TableViewerSorter(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.readSortParams();
    }

    public void sort(Viewer arg0, Object[] arg1) {
        this.readSortParams();
        if (this.sortColumn > -1) {
            super.sort(arg0, arg1);
        }
    }

    private void readSortParams() {
        Table table = this.tableViewer.getTable();
        this.asc = table.getSortDirection() != 1024;
        TableColumn sCol = table.getSortColumn();
        this.sortColumn = sCol != null ? table.indexOf(sCol) : -1;
    }

    public int compare(Viewer viewer, Object row1, Object row2) {
        if (this.sortColumn < 0 || viewer != this.tableViewer) {
            return super.compare(viewer, row1, row2);
        }
        int ret = this.compareAsc(row1, row2);
        return this.asc ? ret : -1 * ret;
    }

    protected int compareAsc(Object row1, Object row2) {
        int defaultRet = super.compare((Viewer)this.tableViewer, row1, row2);
        IBaseLabelProvider labelProvider = this.tableViewer.getLabelProvider();
        if (labelProvider == null || !(labelProvider instanceof ITableLabelProvider)) {
            return defaultRet;
        }
        Object value1 = null;
        Object value2 = null;
        if (labelProvider instanceof TableLabelProvider) {
            TableLabelProvider tableLabelProvider = (TableLabelProvider)labelProvider;
            Object v1 = tableLabelProvider.getValue(row1, this.sortColumn);
            value1 = v1 instanceof Comparable ? (Comparable)v1 : tableLabelProvider.getColumnText(row1, this.sortColumn);
            Object v2 = tableLabelProvider.getValue(row2, this.sortColumn);
            value2 = v2 instanceof Comparable ? (Comparable)v2 : tableLabelProvider.getColumnText(row2, this.sortColumn);
        } else {
            ITableLabelProvider tableLabelProvider = (ITableLabelProvider)labelProvider;
            value1 = tableLabelProvider.getColumnText(row1, this.sortColumn);
            value2 = tableLabelProvider.getColumnText(row2, this.sortColumn);
        }
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (value1 instanceof String && value2 instanceof String) {
            return this.compareAsc((String)value1, (String)value2);
        }
        return this.compareAsc((Comparable)value1, (Comparable)value2);
    }

    protected int compareAsc(String value1, String value2) {
        return this.collator.compare(value1, value2);
    }

    protected int compareAsc(Comparable value1, Comparable value2) {
        if (value1.getClass().equals(value2.getClass())) {
            return value1.compareTo(value2);
        }
        if (value1 instanceof Number && value2 instanceof Number) {
            Double d1 = new Double(((Number)((Object)value1)).doubleValue());
            Double d2 = new Double(((Number)((Object)value2)).doubleValue());
            return d1.compareTo(d2);
        }
        return this.compareAsc(value1.toString(), value2.toString());
    }
}

