/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.Table;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TableRowDeleteButton
extends ch.dvbern.tax.common.presentation.cd.widgets.Composite {
    private Label label;
    private String rowDmk;

    public TableRowDeleteButton(Table parent) {
        super((Composite)parent, 0);
        this.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.label = new Label((Composite)this, 0x800000);
        this.label.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_WHITE));
        this.label.setImage(GuiUtil.getImageRegistry().get("icon.button.delete"));
        this.label.setToolTipText(Messages.getString("label.button.delete", (Control)this.label));
        this.label.setLayoutData((Object)new GridData(1808));
        TableRowDeleteButtonListener listener = new TableRowDeleteButtonListener();
        this.label.addMouseListener((MouseListener)listener);
        this.label.addMouseTrackListener((MouseTrackListener)listener);
    }

    public void setRow(String rowDmk) {
        this.rowDmk = rowDmk;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.label.isEnabled()) {
            this.label.setEnabled(enabled);
        }
        if (!enabled) {
            if (this.label.getImage() != null) {
                this.label.setImage(null);
            }
        } else if (this.label.getImage() == null) {
            this.label.setImage(GuiUtil.getImageRegistry().get("icon.button.delete"));
        }
    }

    private class TableRowDeleteButtonListener
    implements MouseListener,
    MouseTrackListener {
        private TableRowDeleteButtonListener() {
        }

        public void mouseDoubleClick(MouseEvent arg0) {
        }

        public void mouseDown(MouseEvent ev) {
            if (DialogUtil.showYesNoDialog(Messages.getString("message.askTableRowDelete"))) {
                TaxmeController.getInstance().getTmoSession().delete(TableRowDeleteButton.this.rowDmk);
                TaxmeController.getInstance().update();
            }
        }

        public void mouseUp(MouseEvent arg0) {
        }

        public void mouseEnter(MouseEvent arg0) {
        }

        public void mouseExit(MouseEvent arg0) {
        }

        public void mouseHover(MouseEvent arg0) {
        }
    }
}

