/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.parts.IValuePart;
import ch.dvbern.tax.common.presentation.cd.util.ControlReuseUtil;
import ch.dvbern.tax.common.presentation.cd.util.ScrollingFocusListener;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.presentation.cd.widgets.Button;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RadioGroupPart
extends ch.dvbern.tax.common.presentation.cd.widgets.Composite
implements IValuePart {
    private static ScrollingFocusListener focusListener = new ScrollingFocusListener();
    private BorderedLabel text;
    private IValueItem item;
    private ControlReuseUtil controlReuseUtil = new ControlReuseUtil();
    private List focusListeners = new ArrayList();
    private List mouseListeners = new ArrayList();
    private List buttons = new ArrayList();

    public RadioGroupPart(Composite parent) {
        super(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.setLayoutData(gd);
        this.setLayout((Layout)new RowLayout(512));
    }

    public void addFocusListener(FocusListener arg0) {
        this.focusListeners.add(arg0);
        Iterator it = this.buttons.iterator();
        while (it.hasNext()) {
            Button b = (Button)((Object)it.next());
            b.addFocusListener(arg0);
        }
    }

    public void removeFocusListener(FocusListener arg0) {
        this.focusListeners.remove(arg0);
        Iterator it = this.buttons.iterator();
        while (it.hasNext()) {
            Button b = (Button)((Object)it.next());
            b.removeFocusListener(arg0);
        }
    }

    public void addMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.add(arg0);
        Iterator it = this.buttons.iterator();
        while (it.hasNext()) {
            Button b = (Button)((Object)it.next());
            b.addMouseListener(arg0);
        }
    }

    public void removeMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.remove(arg0);
        if (this.text != null) {
            this.text.removeMouseListener(arg0);
        }
        Iterator it = this.buttons.iterator();
        while (it.hasNext()) {
            Button b = (Button)((Object)it.next());
            b.removeMouseListener(arg0);
        }
    }

    public void init(IValueItem item) {
        this.item = item;
        GridData gd = (GridData)this.getLayoutData();
        gd.horizontalSpan = item.getColspan();
        this.setBackground(item.getBackgroundColor());
        this.buttons.clear();
        if (item.getStyle() == 1 || item.getStyle() == 3) {
            this.controlReuseUtil.start();
            this.controlReuseUtil.end();
            if (this.text == null) {
                this.text = new BorderedLabel(this, 0);
                this.text.addFocusListener(focusListener);
            }
            this.text.setFont(item.getFont());
            this.text.setText(item.getRenderedValue());
            this.text.setBackground(item.getBackgroundColor());
            this.text.setForeground(item.getForegroundColor());
        } else {
            if (this.text != null) {
                this.text.dispose();
                this.text = null;
            }
            Locale locale = TaxmeController.getInstance().getLocale();
            Map options = item.getOptionItems().getOptionItems(locale);
            this.controlReuseUtil.start();
            Iterator iter = options.values().iterator();
            while (iter.hasNext()) {
                OptionItemDTO optionItemDTO = (OptionItemDTO)iter.next();
                Button button = (Button)this.controlReuseUtil.getControl(optionItemDTO.getValue());
                if (button == null) {
                    button = new Button(this, 16);
                    this.controlReuseUtil.addControl(optionItemDTO.getValue(), (Control)button);
                    RadioButtonListener li = new RadioButtonListener(button);
                    button.addSelectionListener(li);
                    button.addFocusListener(focusListener);
                    Iterator it = this.focusListeners.iterator();
                    while (it.hasNext()) {
                        FocusListener fli = (FocusListener)it.next();
                        button.addFocusListener(fli);
                    }
                    it = this.mouseListeners.iterator();
                    while (it.hasNext()) {
                        MouseListener mli = (MouseListener)it.next();
                        button.addMouseListener(mli);
                    }
                }
                button.setText(Messages.getString(optionItemDTO.getText().toString(), (Control)button));
                button.setSelection(optionItemDTO.getValue().equals(item.getValue()));
                button.setEnabled(item.getStyle() != 2);
                button.setData(optionItemDTO);
                button.setBackground(item.getBackgroundColor());
                button.setForeground(item.getForegroundColor());
                button.setFont(item.getFont());
                this.buttons.add(button);
            }
            this.controlReuseUtil.end();
        }
    }

    public boolean setFocus() {
        WizardDisplayInfoDTO.ItemItemDTO item = (WizardDisplayInfoDTO.ItemItemDTO)this.getData();
        if (item != null && item.getValue() != null) {
            return super.setFocus();
        }
        return false;
    }

    private class RadioButtonListener
    implements SelectionListener {
        private Button button;

        public RadioButtonListener(Button button) {
            this.button = button;
        }

        public void widgetSelected(SelectionEvent ev) {
            OptionItemDTO value = (OptionItemDTO)this.button.getData();
            if (value.getValue() != null) {
                if (!value.getValue().equals(RadioGroupPart.this.item.getValue())) {
                    RadioGroupPart.this.item.update(value.getValue().toString());
                }
            } else if (RadioGroupPart.this.item.getValue() != null) {
                RadioGroupPart.this.item.update(null);
            }
        }

        public void widgetDefaultSelected(SelectionEvent ev) {
        }
    }
}

