/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import ch.dvbern.tax.common.presentation.cd.parts.IValuePart;
import ch.dvbern.tax.common.presentation.cd.util.ScrollingFocusListener;
import ch.dvbern.tax.common.presentation.cd.widgets.BorderedLabel;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import com.gface.custom.SearchBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ComboboxPart
extends ch.dvbern.tax.common.presentation.cd.widgets.Composite
implements IValuePart {
    private static ScrollingFocusListener focusListener = new ScrollingFocusListener();
    private SearchBox combo;
    private ComboListener li = new ComboListener();
    private Map textMapping = new HashMap();
    private String[] selectionOptions;
    private IValueItem item;
    private BorderedLabel label;
    private List focusListeners = new ArrayList();
    private List mouseListeners = new ArrayList();

    public ComboboxPart(Composite parent) {
        super(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.setLayoutData(gd);
    }

    public void addFocusListener(FocusListener arg0) {
        this.focusListeners.add(arg0);
        if (this.combo != null) {
            this.combo.addFocusListener(arg0);
        }
    }

    public void removeFocusListener(FocusListener arg0) {
        this.focusListeners.remove(arg0);
        if (this.combo != null) {
            this.combo.removeFocusListener(arg0);
        }
    }

    public void addMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.add(arg0);
        if (this.combo != null) {
            this.combo.addMouseListener(arg0);
        }
    }

    public void removeMouseListener(MouseListener arg0) {
        super.addMouseListener(arg0);
        this.mouseListeners.remove(arg0);
        if (this.combo != null) {
            this.combo.removeMouseListener(arg0);
        }
    }

    public void init(IValueItem item) {
        this.item = item;
        if (item.getStyle() == 3) {
            this.initLabel();
        } else {
            this.initCombo();
        }
        this.setBackground(item.getBackgroundColor());
        this.layout();
    }

    private void initLabel() {
        if (this.combo != null) {
            this.combo.dispose();
            this.combo = null;
        }
        if (this.label == null) {
            int align = 16384;
            if ("right".equals(this.item.getAlign())) {
                align = 131072;
            } else if ("center".equals(this.item.getAlign())) {
                align = 0x1000000;
            }
            this.label = new BorderedLabel(this, 0 | align);
            this.label.setLayoutData(new GridData(1808));
        }
        this.label.setFont(this.item.getFont());
        this.label.setText(this.item.getRenderedValue());
        this.label.setBackground(this.item.getBackgroundColor());
        this.label.setForeground(this.item.getForegroundColor());
    }

    private void initCombo() {
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        if (this.combo == null) {
            FocusListener li;
            this.combo = new SearchBox(this, 2048);
            this.combo.setLayoutData(new GridData(768));
            this.combo.addSelectionListener(this.li);
            this.combo.addFocusListener(this.li);
            this.combo.addFocusListener(focusListener);
            this.selectionOptions = null;
            Iterator it = this.focusListeners.iterator();
            while (it.hasNext()) {
                li = (FocusListener)it.next();
                this.combo.addFocusListener(li);
            }
            it = this.mouseListeners.iterator();
            while (it.hasNext()) {
                li = (MouseListener)it.next();
                this.combo.addMouseListener((MouseListener)li);
            }
        }
        this.li.setEnabled(false);
        GridData gd = (GridData)this.getLayoutData();
        gd.horizontalSpan = this.item.getColspan();
        if (this.item.getStyle() != 0) {
            this.initReadOnly();
        } else {
            this.initEnabled();
            this.li.setEnabled(true);
        }
    }

    private void initReadOnly() {
        String[] items = new String[]{this.item.getRenderedValue()};
        this.combo.setItems(items);
        this.combo.select(0);
        this.combo.setEnabled(false);
        if (!ComboboxPart.equals(this.combo.getBackground(), this.item.getBackgroundColor())) {
            this.combo.setBackground(this.item.getBackgroundColor());
        }
        if (!ComboboxPart.equals(this.combo.getFont(), this.item.getFont())) {
            this.combo.setFont(this.item.getFont());
        }
        this.selectionOptions = null;
        this.textMapping.clear();
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return obj2 == null;
    }

    private void initEnabled() {
        if (!this.combo.isEnabled()) {
            this.combo.setEnabled(true);
        }
        this.textMapping.clear();
        Map optionItems = null;
        optionItems = this.item.getOptionItems().isLocalized() ? (Map)this.item.getOptionItems().getOptionItems().get(TaxmeController.getInstance().getLanguage()) : this.item.getOptionItems().getOptionItems();
        Object[] options = new String[optionItems.size()];
        Object newSelection = null;
        int i = 0;
        Iterator iter = optionItems.values().iterator();
        while (iter.hasNext()) {
            OptionItemDTO optionItemDTO = (OptionItemDTO)iter.next();
            options[i] = this.getText(optionItemDTO);
            if (this.isSelected(optionItemDTO)) {
                newSelection = options[i];
            }
            this.textMapping.put(options[i], optionItemDTO);
            ++i;
        }
        if (!Arrays.equals(this.selectionOptions, options)) {
            this.combo.setItems((String[])options);
            this.selectionOptions = options;
        }
        String oldSelection = this.combo.getText();
        if (newSelection == null || oldSelection == null || !oldSelection.equals(newSelection)) {
            int sel;
            if (newSelection != null) {
                String[] comboItems = this.combo.getItems();
                for (sel = 0; comboItems != null && comboItems.length > sel && !comboItems[sel].equals(newSelection); ++sel) {
                }
                if (sel < 0) {
                    this.combo.setItems((String[])options);
                    sel = Arrays.binarySearch(options, newSelection);
                }
            } else if (optionItems.size() > sel) {
                OptionItemDTO optionItem = (OptionItemDTO)optionItems.values().toArray()[sel];
                this.item.setDefaultValue(optionItem.getValue().toString());
            }
            if (sel < this.combo.getItemCount()) {
                this.combo.select(sel);
            }
        }
        if (!ComboboxPart.equals(this.combo.getFont(), this.item.getFont())) {
            this.combo.setFont(this.item.getFont());
        }
        if (!ComboboxPart.equals(this.combo.getForeground(), this.item.getForegroundColor())) {
            this.combo.setForeground(this.item.getForegroundColor());
        }
        if (!ComboboxPart.equals(this.combo.getBackground(), this.item.getBackgroundColor())) {
            this.combo.setBackground(this.item.getBackgroundColor());
        }
    }

    public boolean setFocus() {
        if (this.combo != null && this.combo.isEnabled()) {
            return this.combo.setFocus();
        }
        return false;
    }

    private String getText(OptionItemDTO optionItem) {
        if (optionItem.isResourceKey()) {
            return Messages.getString(optionItem.getText().toString());
        }
        return optionItem.getText().toString();
    }

    private boolean isSelected(OptionItemDTO optionItem) {
        Object value = optionItem.getValue();
        if (value != null) {
            return value.equals(this.item.getValue());
        }
        return optionItem.getValue() == null;
    }

    private class ComboListener
    implements SelectionListener,
    FocusListener {
        private boolean enabled = false;

        private ComboListener() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        private void validate() {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
            OptionItemDTO value = null;
            String selected = ComboboxPart.this.combo.getText();
            if (selected != null) {
                value = (OptionItemDTO)ComboboxPart.this.textMapping.get(selected);
            }
            if (value != null && value.getValue() != null) {
                ComboboxPart.this.item.update(value.getValue().toString());
            } else if (ComboboxPart.this.item.getValue() != null || ComboboxPart.this.item.isValidateIfLeftEmpty()) {
                ComboboxPart.this.item.update(null);
            }
            this.enabled = true;
        }

        public void widgetSelected(SelectionEvent ev) {
            if (!this.enabled) {
                return;
            }
            this.validate();
        }

        public void focusLost(FocusEvent ev) {
            if (!this.enabled) {
                return;
            }
            if (ComboboxPart.this.item.getState() == 3) {
                this.validate();
            }
        }

        public void widgetDefaultSelected(SelectionEvent ev) {
        }

        public void focusGained(FocusEvent ev) {
        }
    }
}

