/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.items.IButtonItem;
import ch.dvbern.tax.common.presentation.cd.parts.IButtonPart;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommand;
import ch.dvbern.tax.common.presentation.cd.util.ButtonCommands;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import ch.dvbern.tax.common.presentation.cd.widgets.Button;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ButtonPart
extends ch.dvbern.tax.common.presentation.cd.widgets.Composite
implements IButtonPart {
    private static final Logger log = Logger.getLogger((Class)ButtonPart.class);
    private Button button;
    private Label label;
    private ButtonCommand cmd;
    private IButtonItem buttonDTO;

    public ButtonPart(Composite parent) {
        super(parent, 0);
        this.setLayoutData(new GridData());
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
    }

    public void init(IButtonItem item) {
        this.buttonDTO = item;
        if (item.getIcon() == null) {
            if (this.label != null) {
                this.label.dispose();
                this.label = null;
            }
            this.initButton();
        } else {
            if (this.button != null) {
                this.button.dispose();
                this.button = null;
            }
            this.initLabel();
        }
        GridData gd = (GridData)this.getLayoutData();
        gd.horizontalSpan = this.buttonDTO.getColspan();
        this.setBackground(this.buttonDTO.getBackgroundColor());
        this.cmd = ButtonCommands.get(this.buttonDTO.getUri());
        if (this.cmd != null) {
            this.cmd.init(this.buttonDTO);
        } else {
            log.warn((Object)("Not registered ButtonCommand: " + this.buttonDTO.getUri()));
        }
    }

    private void initButton() {
        if (this.button == null) {
            this.button = new Button(this, 64);
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ButtonPart.this.cmd.execute(ButtonPart.this.buttonDTO);
                }
            });
            this.button.setFont(GuiUtil.getFontRegistry().get("font.normal"));
            this.button.setBackground(GuiUtil.getColorRegistry().get(GuiUtil.COLOR_GREY_LIGHT));
            this.button.setLayoutData(new GridData(68));
        }
        this.button.setText(Messages.getString(this.buttonDTO.getNameKey(), (Control)this.button));
        this.button.setEnabled(this.buttonDTO.isEnabled());
    }

    private void initLabel() {
        if (this.label == null) {
            this.label = new Label((Composite)this, 0);
            this.label.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent ev) {
                    if (ButtonPart.this.buttonDTO.isEnabled()) {
                        ButtonPart.this.getParent().traverse(16);
                        ButtonPart.this.cmd.execute(ButtonPart.this.buttonDTO);
                    }
                }
            });
            this.label.setFont(GuiUtil.getFontRegistry().get("font.normal"));
            this.label.setLayoutData((Object)new GridData(68));
        }
        this.label.setImage(this.buttonDTO.getIcon());
        if (this.buttonDTO.getNameKey() != null) {
            this.label.setToolTipText(Messages.getString(this.buttonDTO.getNameKey(), (Control)this.button));
        }
        this.label.setEnabled(this.buttonDTO.isEnabled());
        this.label.setBackground(this.buttonDTO.getBackgroundColor());
    }
}

